/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.prefs;

import java.util.List;
import org.openvpms.archetype.rules.util.MappingCopyHandler;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

class PreferencesCopier
extends MappingCopyHandler {
    public PreferencesCopier() {
        this.setDefaultTreatment(MappingCopyHandler.Treatment.REFERENCE);
    }

    public static List<IMObject> copy(Entity prefs, Reference party, IArchetypeService service) {
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new PreferencesCopier(), (ArchetypeService)service);
        List objects = copier.apply((IMObject)prefs);
        Entity root = (Entity)objects.get(0);
        IMObjectBean bean = service.getBean((IMObject)root);
        bean.setTarget("user", party);
        return objects;
    }

    @Override
    protected MappingCopyHandler.Treatment getTreatment(IMObject object) {
        if (object.isA(new String[]{"entity.preferences", "entity.preferenceGroup*", "entityLink.preferenceGroup*"})) {
            return MappingCopyHandler.Treatment.COPY;
        }
        if (object.isA("entityLink.preferencesUser")) {
            return MappingCopyHandler.Treatment.EXCLUDE;
        }
        return super.getTreatment(object);
    }

    protected boolean isCopyable(ArchetypeDescriptor archetype, NodeDescriptor node, boolean source) {
        return super.isCopyable(archetype, node, source) && !node.isHidden();
    }
}

