/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.laboratory;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;

public class LaboratoryRules {
    private final IArchetypeService service;
    private static final String LABORATORY = "laboratory";
    private static final String LOCATION = "location";

    public LaboratoryRules(IArchetypeService service) {
        this.service = service;
    }

    public Entity getLaboratory(Entity investigationType) {
        return this.getLaboratory(this.service.getBean((IMObject)investigationType));
    }

    public Entity getLaboratory(Entity investigationType, Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)investigationType);
        return this.getLaboratory(bean, location);
    }

    public Entity getLaboratory(IMObjectBean investigationType, Party location) {
        Entity laboratory = this.getLaboratory(investigationType);
        Entity result = null;
        if (laboratory != null) {
            if (laboratory.isA("entity.HL7ServiceLaboratoryGroup")) {
                result = this.getGroupLaboratory(laboratory, location);
            } else if (laboratory.isA(new String[]{"entity.laboratoryService*", "entity.HL7ServiceLaboratory"}) && this.canUseAtLocation(laboratory, location.getObjectReference())) {
                result = laboratory;
            }
        }
        return result;
    }

    public Act createOrder(Act investigation) {
        if (investigation.isNew()) {
            throw new IllegalStateException("Cannot create orders for unsaved investigations");
        }
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        Act order = (Act)this.service.create("act.laboratoryOrder", Act.class);
        order.setActivityStartTime(investigation.getActivityStartTime());
        ActIdentity identity = (ActIdentity)this.service.create("actIdentity.patientInvestigation", ActIdentity.class);
        identity.setIdentity(Long.toString(investigation.getId()));
        order.addIdentity(identity);
        order.setDescription(investigation.getDescription());
        IMObjectBean orderBean = this.service.getBean((IMObject)order);
        orderBean.setValue("type", (Object)"NEW");
        orderBean.setTarget("patient", bean.getTargetRef("patient"));
        orderBean.setTarget(LABORATORY, bean.getTargetRef(LABORATORY));
        orderBean.setTarget("investigationType", bean.getTargetRef("investigationType"));
        orderBean.setTarget(LOCATION, bean.getTargetRef(LOCATION));
        orderBean.setTarget("clinician", bean.getTargetRef("clinician"));
        orderBean.setTarget("device", bean.getTargetRef("device"));
        for (Reference test : bean.getTargetRefs("tests")) {
            orderBean.addTarget("tests", test);
        }
        bean.addTarget("order", (IMObject)order, "investigation");
        return order;
    }

    public boolean isUnsubmittedInvestigation(Act investigation) {
        String orderStatus;
        boolean result = false;
        if (!"CANCELLED".equals(investigation.getStatus()) && ("PENDING".equals(orderStatus = investigation.getStatus2()) || "CONFIRM".equals(orderStatus) || "CONFIRM_DEFERRED".equals(orderStatus))) {
            IMObjectBean bean = this.service.getBean((IMObject)investigation);
            Reference laboratory = bean.getTargetRef(LABORATORY);
            result = laboratory != null && laboratory.isA("entity.laboratoryService*");
        }
        return result;
    }

    public boolean canUseLaboratoryAtLocation(Entity laboratory, Party location) {
        boolean result = laboratory.isA("entity.HL7ServiceLaboratoryGroup") ? this.getGroupLaboratory(laboratory, location) != null : this.canUseAtLocation(laboratory, location.getObjectReference());
        return result;
    }

    public boolean canUseDeviceAtLocation(Entity device, Party location) {
        return this.canUseAtLocation(device, location.getObjectReference());
    }

    public Entity getTest(String archetype, String code) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.laboratoryTest"});
        Join identity = root.join("code", archetype);
        identity.on((Expression)builder.equal((Expression)identity.get("identity"), (Object)code));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (Entity)this.service.createQuery(query).getFirstResult();
    }

    public List<Product> getProducts(Entity test) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Product.class);
        Root root = query.from(Product.class, new String[]{"product.medication", "product.merchandise", "product.service"});
        Join tests = root.join("tests");
        tests.on((Expression)builder.equal((Expression)tests.get("target"), (Object)test.getObjectReference()));
        query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        return this.service.createQuery(query).getResultList();
    }

    private Entity getLaboratory(IMObjectBean investigationType) {
        return (Entity)investigationType.getTarget(LABORATORY, Entity.class);
    }

    private Entity getGroupLaboratory(Entity group, Party location) {
        IMObjectBean bean = this.service.getBean((IMObject)group);
        return this.getGroupLaboratory(bean, location);
    }

    private Entity getGroupLaboratory(IMObjectBean group, Party location) {
        Entity result = null;
        Reference reference = location.getObjectReference();
        List laboratories = group.getTargets("services", Entity.class);
        if (!laboratories.isEmpty()) {
            laboratories.sort(Comparator.comparingLong(IMObject::getId));
        }
        for (Entity laboratory : laboratories) {
            if (!this.canUseAtLocation(laboratory, reference)) continue;
            result = laboratory;
            break;
        }
        return result;
    }

    private boolean canUseAtLocation(Entity laboratory, Reference location) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)laboratory);
        if (laboratory.isA(new String[]{"entity.laboratoryService*", "entity.laboratoryDevice*"})) {
            List locations = bean.getTargetRefs("locations");
            result = locations.isEmpty() || locations.contains(location);
        } else if (laboratory.isA("entity.HL7ServiceLaboratory")) {
            result = Objects.equals(location, bean.getTargetRef(LOCATION));
        }
        return result;
    }
}

