/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.till;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.deposit.DepositHelper;
import org.openvpms.archetype.rules.finance.till.TillBalanceRules;
import org.openvpms.archetype.rules.finance.till.TillHelper;
import org.openvpms.archetype.rules.finance.till.TillRuleException;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TillRules {
    private final IArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final TillBalanceRules rules;
    private static final String AMOUNT = "amount";

    public TillRules(IArchetypeRuleService service, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.transactionManager = transactionManager;
        this.rules = new TillBalanceRules((IArchetypeService)service);
    }

    public boolean needsDrawerOpen(Act act) {
        boolean result = false;
        if ("POSTED".equals(act.getStatus()) && act.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            for (Act item : bean.getTargets("items", Act.class)) {
                IMObjectBean itemBean;
                BigDecimal cashout;
                if (item.isA(new String[]{"act.customerAccountPaymentCash", "act.customerAccountPaymentCheque", "act.customerAccountPaymentCredit", "act.customerAccountRefundCash", "act.customerAccountRefundCheque", "act.customerAccountRefundCredit"})) {
                    result = true;
                    break;
                }
                if (!item.isA("act.customerAccountPaymentEFT") || (cashout = (itemBean = this.service.getBean((IMObject)item)).getBigDecimal("cashout", BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public boolean isClearInProgress(Entity till) {
        Reference reference = till.getObjectReference();
        return this.isClearInProgress(reference);
    }

    public boolean isClearInProgress(Reference till) {
        ArchetypeQuery query = new ArchetypeQuery("act.tillBalance", false, true);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"IN_PROGRESS")).add((IConstraint)Constraints.join((String)"till").add((IConstraint)Constraints.eq((String)"entity", (Reference)till)));
        query.add((IConstraint)new NodeSelectConstraint("id"));
        query.setMaxResults(1);
        return new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query).hasNext();
    }

    public void startClearTill(final FinancialAct balance, final BigDecimal cashFloat) {
        if (!balance.getStatus().equals("UNCLEARED")) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidStatusForStartClear, balance.getStatus());
        }
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                if (TillRules.this.isClearInProgress(TillHelper.getTillRef((Act)balance, TillRules.this.service))) {
                    throw new TillRuleException(TillRuleException.ErrorCode.ClearInProgress, new Object[0]);
                }
                balance.setStatus("IN_PROGRESS");
                Till till = TillRules.this.getTillBean((Act)balance);
                TillRules.this.addAdjustment(balance, cashFloat, till);
                TillRules.this.service.save((IMObject)balance);
                till.setTillFloat(cashFloat);
                till.setLastCleared(new Date());
                till.save();
            }
        });
    }

    public void addToBalance(FinancialAct balance, FinancialAct item) {
        Reference itemTill;
        Reference balanceTill = TillHelper.getTillRef((Act)balance, this.service);
        if (!balanceTill.equals((Object)(itemTill = TillHelper.getTillRef((Act)balance, this.service)))) {
            throw new TillRuleException(TillRuleException.ErrorCode.DifferentTills, DescriptorHelper.getDisplayName((IMObject)item, (ArchetypeService)this.service));
        }
        if ("CLEARED".equals(balance.getStatus())) {
            throw new TillRuleException(TillRuleException.ErrorCode.ClearedTill, balance.getId());
        }
        IMObjectBean bean = this.service.getBean((IMObject)balance);
        bean.addTarget("item", (IMObject)item, "balance");
        this.service.save(Arrays.asList(balance, item));
    }

    public void clearTill(final FinancialAct balance, final Party account) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TillRules.this.clearInProgressTill(balance, account);
            }
        });
    }

    public void clearTill(final FinancialAct balance, final BigDecimal cashFloat, final Party account) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                TillRules.this.clearUnclearedTill(balance, cashFloat, account);
            }
        });
    }

    public void transfer(Act balance, Act act, Entity till) {
        IMObjectBean balanceBean = this.service.getBean((IMObject)balance);
        if (!balanceBean.isA(new String[]{"act.tillBalance"})) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidTillArchetype, balance.getArchetype());
        }
        IMObjectBean actBean = this.service.getBean((IMObject)act);
        if (!actBean.isA(new String[]{"act.customerAccountPayment", "act.customerAccountRefund"})) {
            throw new TillRuleException(TillRuleException.ErrorCode.CantAddActToTill, act.getArchetype());
        }
        Entity orig = TillHelper.getTill(balance, this.service);
        if (orig.equals(till)) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidTransferTill, till.getName());
        }
        if ("CLEARED".equals(balance.getStatus())) {
            throw new TillRuleException(TillRuleException.ErrorCode.ClearedTill, balance.getId());
        }
        if (actBean.getObject("till") == null) {
            throw new TillRuleException(TillRuleException.ErrorCode.MissingTill, act.getId());
        }
        ActRelationship relationship = (ActRelationship)balanceBean.getValue("items", ActRelationship.class, Predicates.targetEquals((IMObject)act));
        if (relationship == null) {
            throw new TillRuleException(TillRuleException.ErrorCode.MissingRelationship, balance.getId());
        }
        balance.removeActRelationship(relationship);
        act.removeActRelationship(relationship);
        actBean.setTarget("till", (IMObject)till);
        TillHelper.updateBalance(balanceBean, this.service);
        List<Act> toSave = this.rules.addToBalance(act);
        toSave.add(balance);
        this.service.save(toSave);
    }

    public boolean updateBalance(FinancialAct balance) {
        return this.rules.updateBalance(balance);
    }

    private void clearUnclearedTill(FinancialAct balance, BigDecimal cashFloat, Party account) {
        String status = balance.getStatus();
        if (!"UNCLEARED".equals(status)) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidStatusForClear, status);
        }
        Till till = this.getTillBean((Act)balance);
        this.addAdjustment(balance, cashFloat, till);
        this.depositBalance(balance, account);
        till.setLastCleared(new Date());
        till.setTillFloat(cashFloat);
        till.save();
    }

    private void addAdjustment(FinancialAct balance, BigDecimal cashFloat, Till till) {
        BigDecimal lastCashFloat = till.getTillFloat();
        BigDecimal diff = cashFloat.subtract(lastCashFloat);
        if (diff.compareTo(BigDecimal.ZERO) != 0) {
            boolean credit = lastCashFloat.compareTo(cashFloat) > 0;
            FinancialAct adjustment = this.createTillBalanceAdjustment(till.getEntity(), diff.abs(), credit);
            IMObjectBean balanceBean = this.service.getBean((IMObject)balance);
            balanceBean.addTarget("items", (IMObject)adjustment, "tillBalance");
            this.service.save((IMObject)adjustment);
            TillHelper.updateBalance(balanceBean, this.service);
        }
    }

    private void clearInProgressTill(FinancialAct balance, Party account) {
        String status = balance.getStatus();
        if (!"IN_PROGRESS".equals(status)) {
            throw new TillRuleException(TillRuleException.ErrorCode.InvalidStatusForClear, status);
        }
        this.depositBalance(balance, account);
    }

    private void depositBalance(FinancialAct balance, Party account) {
        balance.setStatus("CLEARED");
        balance.setActivityEndTime(new Date());
        FinancialAct deposit = DepositHelper.getUndepositedDeposit((Entity)account, this.service);
        if (deposit == null) {
            deposit = DepositHelper.createBankDeposit((Entity)account, this.service);
        }
        IMObjectBean depositBean = this.service.getBean((IMObject)deposit);
        ActRelationship relationship = (ActRelationship)depositBean.addTarget("items", (IMObject)balance);
        balance.addActRelationship(relationship);
        this.service.save((IMObject)balance);
        this.updateDepositTotal(depositBean);
        this.service.save((IMObject)deposit);
    }

    private FinancialAct createTillBalanceAdjustment(Entity till, BigDecimal amount, boolean credit) {
        FinancialAct act = (FinancialAct)this.service.create("act.tillBalanceAdjustment", FinancialAct.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue(AMOUNT, (Object)amount);
        bean.setValue("credit", (Object)credit);
        bean.setTarget("till", (IMObject)till);
        return act;
    }

    private void updateDepositTotal(IMObjectBean depositBean) {
        ActCalculator calc = new ActCalculator((ArchetypeService)this.service);
        BigDecimal total = calc.sum((Act)depositBean.getObject(Act.class), "items", AMOUNT);
        depositBean.setValue(AMOUNT, (Object)total);
    }

    private Till getTillBean(Act act) {
        return new Till(TillHelper.getTill(act, this.service), this.service);
    }

    private static class Till {
        private final IMObjectBean bean;

        private Till(Entity entity, IArchetypeService service) {
            this.bean = service.getBean((IMObject)entity);
        }

        public BigDecimal getTillFloat() {
            return this.bean.getBigDecimal("tillFloat", BigDecimal.ZERO);
        }

        public void setTillFloat(BigDecimal value) {
            this.bean.setValue("tillFloat", (Object)value);
        }

        public void setLastCleared(Date date) {
            this.bean.setValue("lastCleared", (Object)date);
        }

        public Entity getEntity() {
            return (Entity)this.bean.getObject(Entity.class);
        }

        public void save() {
            this.bean.save();
        }
    }
}

