/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.statement;

import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import org.openvpms.archetype.rules.finance.statement.StatementActHelper;
import org.openvpms.component.model.party.Party;

class StatementPeriod {
    private final Date statementTime;
    private boolean statement;
    private Date openTime;
    private final Date closeTime;
    private BigDecimal openingBalance = BigDecimal.ZERO;
    private boolean printed;

    public StatementPeriod(Party customer, Date statementDate, StatementActHelper helper) {
        StatementActHelper.ActState close;
        this.statementTime = helper.getStatementTimestamp(statementDate);
        StatementActHelper.ActState open = helper.getOpeningBalanceState(customer, this.statementTime);
        if (open != null) {
            this.openTime = open.getStartTime();
            this.openingBalance = open.getAmount();
        }
        if ((close = helper.getClosingBalanceState(customer, this.statementTime, this.openTime)) != null) {
            this.closeTime = close.getStartTime();
            this.printed = close.isPrinted();
            this.statement = true;
        } else {
            this.closeTime = StatementPeriod.getClosingBalanceTimestamp(this.statementTime);
        }
    }

    public Date getStatementTimestamp() {
        return this.statementTime;
    }

    public boolean hasStatement() {
        return this.statement;
    }

    public Date getOpeningBalanceTimestamp() {
        return this.openTime;
    }

    public BigDecimal getOpeningBalance() {
        return this.openingBalance;
    }

    public Date getClosingBalanceTimestamp() {
        return this.closeTime;
    }

    public Date getCompletedChargeTimestamp() {
        return StatementPeriod.getTimestamp(this.statementTime, -1);
    }

    public Date getFeeTimestamp() {
        return StatementPeriod.getFeeTimestamp(this.statementTime);
    }

    public boolean isPrinted() {
        return this.printed;
    }

    public static Date getFeeTimestamp(Date statementTime) {
        return StatementPeriod.getTimestamp(statementTime, 1);
    }

    public static Date getClosingBalanceTimestamp(Date statementTime) {
        return StatementPeriod.getTimestamp(statementTime, 2);
    }

    private static Date getTimestamp(Date statementTime, int addSeconds) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(statementTime);
        calendar.add(13, addSeconds);
        return calendar.getTime();
    }
}

