/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.order;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;

public abstract class CustomerOrder {
    private final Party patient;
    private final Party customer;
    private final String note;
    private final Reference location;
    private final List<Act> acts = new ArrayList<Act>();
    private final IArchetypeService service;
    private IMObjectBean orderBean;
    private IMObjectBean returnBean;
    private static final String NOTES = "notes";

    protected CustomerOrder(Party patient, Party customer, String note, Reference location, IArchetypeService service) {
        this.patient = patient;
        this.customer = customer;
        this.note = note;
        this.location = location;
        this.service = service;
    }

    protected CustomerOrder(Act act, boolean isOrder, IArchetypeService service) {
        IMObjectBean bean = service.getBean((IMObject)act);
        if (isOrder) {
            this.orderBean = bean;
        } else {
            this.returnBean = bean;
        }
        List items = bean.getTargets("items", Act.class);
        this.customer = (Party)bean.getTarget("customer", Party.class);
        this.note = bean.getString(NOTES);
        this.location = bean.getTargetRef("location");
        if (!items.isEmpty()) {
            IMObjectBean itemBean = service.getBean((IMObject)items.get(0));
            this.patient = (Party)itemBean.getTarget("patient", Party.class);
        } else {
            this.patient = null;
        }
        this.service = service;
        this.acts.add(act);
        this.acts.addAll(items);
    }

    public Party getPatient() {
        return this.patient;
    }

    public IMObjectBean getOrder() {
        if (this.orderBean == null) {
            this.orderBean = this.createOrder();
        }
        return this.orderBean;
    }

    public IMObjectBean getReturn() {
        if (this.returnBean == null) {
            this.returnBean = this.createReturn();
        }
        return this.returnBean;
    }

    public boolean hasOrder() {
        return this.orderBean != null;
    }

    public abstract IMObjectBean createOrderItem();

    public abstract IMObjectBean createReturnItem();

    public List<Act> getActs() {
        return this.acts;
    }

    public void save() {
        this.service.save(this.acts);
    }

    public void remove() {
        if (this.orderBean != null) {
            this.service.remove(this.orderBean.getObject());
        }
        if (this.returnBean != null) {
            this.service.remove(this.returnBean.getObject());
        }
    }

    public static void addNote(IMObjectBean bean, String value) {
        String notes = bean.getString(NOTES);
        notes = !StringUtils.isEmpty((CharSequence)notes) ? notes + "\n" + value : value;
        bean.setValue(NOTES, (Object)StringUtils.abbreviate((String)notes, (int)bean.getMaxLength(NOTES)));
    }

    protected abstract IMObjectBean createOrder();

    protected abstract IMObjectBean createReturn();

    protected IMObjectBean createParent(String archetype) {
        Act act = (Act)this.service.create(archetype, Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (this.customer != null) {
            bean.setTarget("customer", (IMObject)this.customer);
        }
        if (this.location != null) {
            bean.setTarget("location", this.location);
        }
        if (this.note != null) {
            CustomerOrder.addNote(bean, this.note);
        }
        this.acts.add(act);
        return bean;
    }

    protected IMObjectBean createItem(String archetype, IMObjectBean parent) {
        Act act = (Act)this.service.create(archetype, Act.class);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (this.patient != null) {
            bean.setTarget("patient", (IMObject)this.patient);
        }
        ActRelationship relationship = (ActRelationship)parent.addTarget("items", (IMObject)act);
        act.addActRelationship(relationship);
        this.acts.add(act);
        return bean;
    }

    protected IMObjectBean getItem(String archetype, Product product) {
        Reference reference = product != null ? product.getObjectReference() : null;
        for (Act act : this.acts) {
            IMObjectBean bean;
            if (!act.isA(archetype) || !Objects.equals(reference, (bean = this.service.getBean((IMObject)act)).getTargetRef("product"))) continue;
            return bean;
        }
        return null;
    }
}

