/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.finance.account;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import org.openvpms.archetype.rules.act.ActCalculator;
import org.openvpms.archetype.rules.finance.account.CustomerAccountArchetypes;
import org.openvpms.archetype.rules.finance.account.CustomerAccountQueryFactory;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRuleException;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.Constraints;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.NamedQuery;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.ObjectRefSelectConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;

public class BalanceCalculator {
    private final IArchetypeService service;
    private static final String START_TIME = "startTime";
    private static final String ACT_AMOUNT = "act.amount";
    private static final String ACT_CREDIT = "act.credit";
    private static final String ACT_ALLOCATED_AMOUNT = "act.allocatedAmount";

    public BalanceCalculator(IArchetypeService service) {
        this.service = service;
    }

    public BigDecimal getBalance(Party customer) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedObjectSetQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return this.calculateBalance((Iterator<ObjectSet>)iterator);
    }

    public BigDecimal getBalance(Party customer, Date date) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedObjectSetQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)date));
        return this.calculateBalance((Iterator<ObjectSet>)iterator);
    }

    public BigDecimal getBalance(Party customer, Date from, Date to, boolean inclusive, BigDecimal openingBalance) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createObjectSetQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS, true);
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"POSTED"));
        if (from != null) {
            query.add((IConstraint)Constraints.gte((String)START_TIME, (Object)from));
        }
        if (to != null) {
            if (inclusive) {
                query.add((IConstraint)Constraints.lte((String)START_TIME, (Object)to));
            } else {
                query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)to));
            }
        }
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return this.calculateDefinitiveBalance((Iterator<ObjectSet>)iterator, openingBalance);
    }

    public BigDecimal getDefinitiveBalance(Party customer) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createQuery(customer, CustomerAccountArchetypes.ACCOUNT_ACTS);
        query.add((IConstraint)Constraints.sort((String)START_TIME));
        query.add((IConstraint)Constraints.sort((String)"id"));
        query.add((IConstraint)new ObjectRefSelectConstraint("act"));
        query.add((IConstraint)new NodeSelectConstraint("amount"));
        query.add((IConstraint)new NodeSelectConstraint("credit"));
        query.add((IConstraint)Constraints.eq((String)"status", (Object)"POSTED"));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        BigDecimal total = BigDecimal.ZERO;
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.service);
        while (iterator.hasNext()) {
            ObjectSet set = (ObjectSet)iterator.next();
            BigDecimal amount = set.getBigDecimal(ACT_AMOUNT, BigDecimal.ZERO);
            boolean credit = set.getBoolean(ACT_CREDIT);
            IMObjectReference act = set.getReference("act.reference");
            if (act.isA(new String[]{"act.customerAccountOpeningBalance", "act.customerAccountClosingBalance"})) {
                BigDecimal balance;
                if (act.isA("act.customerAccountClosingBalance")) {
                    credit = !credit;
                }
                if ((balance = credit ? amount.negate() : amount).compareTo(total) == 0) continue;
                throw new CustomerAccountRuleException(CustomerAccountRuleException.ErrorCode.InvalidBalance, act.getArchetype(), total, balance);
            }
            total = calculator.addAmount(total, amount, credit);
        }
        return total;
    }

    public BigDecimal getOverdueBalance(Party customer, Date date) {
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnallocatedObjectSetQuery(customer, CustomerAccountArchetypes.DEBITS_CREDITS);
        query.add((IConstraint)Constraints.lt((String)START_TIME, (Object)date));
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        BigDecimal amount = this.calculateBalance((Iterator<ObjectSet>)iterator);
        if (amount.compareTo(BigDecimal.ZERO) < 0) {
            amount = BigDecimal.ZERO;
        }
        return amount;
    }

    public BigDecimal getOverdueBalance(Party customer, Date date, Date overdueDate) {
        NamedQuery query = new NamedQuery("getOverdueAmounts", Arrays.asList("id", "total", "allocatedTotal", "allocatedAmount", "overdueAllocationTime"));
        query.setMaxResults(-1);
        query.setParameter("customer", (Object)customer.getId());
        query.setParameter("date", (Object)date);
        query.setParameter("overdueDate", (Object)overdueDate);
        ObjectSetQueryIterator iter = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        long lastId = -1L;
        BigDecimal total = BigDecimal.ZERO;
        BigDecimal allocatedTotal = BigDecimal.ZERO;
        BigDecimal result = BigDecimal.ZERO;
        while (iter.hasNext()) {
            ObjectSet set = (ObjectSet)iter.next();
            long uid = set.getLong("id");
            if (uid != lastId) {
                if (lastId != -1L) {
                    result = result.add(total).subtract(allocatedTotal);
                }
                total = set.getBigDecimal("total", BigDecimal.ZERO);
                allocatedTotal = set.getBigDecimal("allocatedTotal", BigDecimal.ZERO);
                lastId = uid;
            }
            BigDecimal allocatedAmount = set.getBigDecimal("allocatedAmount", BigDecimal.ZERO);
            Date overdueAllocationTime = set.getDate("overdueAllocationTime");
            if (overdueAllocationTime == null) continue;
            allocatedTotal = allocatedTotal.subtract(allocatedAmount);
        }
        result = result.add(total).subtract(allocatedTotal);
        return result;
    }

    public BigDecimal getUnbilledAmount(Party customer) {
        String[] shortNames = new String[]{"act.customerAccountChargesInvoice", "act.customerAccountChargesCounter", "act.customerAccountChargesCredit"};
        ArchetypeQuery query = CustomerAccountQueryFactory.createUnbilledObjectSetQuery(customer, shortNames);
        ObjectSetQueryIterator iterator = new ObjectSetQueryIterator(this.service, (IArchetypeQuery)query);
        return this.calculateBalance((Iterator<ObjectSet>)iterator);
    }

    public BigDecimal getAllocatable(FinancialAct act) {
        return this.getAllocatable(act.getTotal(), act.getAllocatedAmount());
    }

    public BigDecimal getAllocatable(BigDecimal amount, BigDecimal allocated) {
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        if (allocated == null) {
            allocated = BigDecimal.ZERO;
        }
        return amount.abs().subtract(allocated);
    }

    public boolean isAllocated(FinancialAct act) {
        return this.getAllocatable(act).compareTo(BigDecimal.ZERO) == 0;
    }

    protected BigDecimal calculateBalance(Iterator<ObjectSet> iterator) {
        BigDecimal total = BigDecimal.ZERO;
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.service);
        while (iterator.hasNext()) {
            ObjectSet set = iterator.next();
            BigDecimal amount = set.getBigDecimal(ACT_AMOUNT, BigDecimal.ZERO);
            BigDecimal allocated = set.getBigDecimal(ACT_ALLOCATED_AMOUNT, BigDecimal.ZERO);
            boolean credit = set.getBoolean(ACT_CREDIT);
            if (amount.signum() == -1) {
                credit = !credit;
            }
            BigDecimal unallocated = this.getAllocatable(amount, allocated);
            total = calculator.addAmount(total, unallocated, credit);
        }
        return total;
    }

    protected BigDecimal calculateDefinitiveBalance(Iterator<ObjectSet> iterator, BigDecimal openingBalance) {
        BigDecimal total = openingBalance;
        ActCalculator calculator = new ActCalculator((ArchetypeService)this.service);
        while (iterator.hasNext()) {
            ObjectSet set = iterator.next();
            BigDecimal amount = set.getBigDecimal(ACT_AMOUNT, BigDecimal.ZERO);
            boolean credit = set.getBoolean(ACT_CREDIT);
            total = calculator.addAmount(total, amount, credit);
        }
        return total;
    }
}

