/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

public class LongTextReader {
    private final ArchetypeService service;

    public LongTextReader(ArchetypeService service) {
        this.service = service;
    }

    public String getText(DocumentAct act) {
        Document document;
        String text = null;
        Reference reference = act.getDocument();
        if (TypeHelper.isA((Reference)reference, (String)"document.text") && (document = (Document)this.service.get(reference, Document.class)) != null) {
            text = TextDocumentHandler.asString(document);
        }
        return text;
    }

    public String getText(DocumentAct act, String node) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        String text = bean.getString(node);
        if (text == null) {
            text = this.getText(act);
        }
        return text;
    }

    public String getText(IMObject object, String node, String relationshipNode) {
        DocumentAct act;
        IMObjectBean bean = this.service.getBean(object);
        String text = bean.getString(node);
        if (text == null && (act = (DocumentAct)bean.getTarget(relationshipNode, DocumentAct.class)) != null) {
            text = this.getText(act);
        }
        return text;
    }
}

