/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.IIORegistry;
import javax.imageio.stream.ImageInputStream;
import org.openvpms.archetype.rules.doc.AbstractDocumentHandler;
import org.openvpms.archetype.rules.doc.DocumentException;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.ClassHelper;

public class ImageDocumentHandler
extends AbstractDocumentHandler {
    public ImageDocumentHandler(ArchetypeService service) {
        super("document.image", service);
        this.initImageIO();
    }

    @Override
    public Document create(String name, InputStream stream, String mimeType, int size) {
        Document document;
        ReusableInputStream buffered = new ReusableInputStream(stream);
        try {
            Dimension dimension = this.getDimension(buffered);
            buffered.reset();
            buffered.mark(0);
            document = super.create(name, buffered, mimeType, size);
            this.updateDimension(document, dimension);
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, name, exception);
        }
        finally {
            buffered.realClose();
        }
        return document;
    }

    @Override
    public void update(Document document, InputStream stream, String mimeType, int size) {
        ReusableInputStream buffered = new ReusableInputStream(stream);
        try {
            Dimension dimension = this.getDimension(buffered);
            buffered.reset();
            buffered.mark(0);
            super.update(document, buffered, mimeType, size);
            this.updateDimension(document, dimension);
        }
        catch (IOException exception) {
            throw new DocumentException(DocumentException.ErrorCode.ReadError, "stream", exception);
        }
        finally {
            buffered.realClose();
        }
    }

    private void initImageIO() {
        ClassHelper.invoke((ClassLoader)this.getClass().getClassLoader(), IIORegistry::getDefaultInstance);
    }

    private void updateDimension(Document document, Dimension dimension) {
        Integer width = dimension.width != -1 ? Integer.valueOf(dimension.width) : null;
        Integer height = dimension.width != -1 ? Integer.valueOf(dimension.height) : null;
        IMObjectBean bean = this.getService().getBean((IMObject)document);
        bean.setValue("width", (Object)width);
        bean.setValue("height", (Object)height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dimension getDimension(InputStream stream) throws IOException {
        int height;
        int width;
        block15: {
            width = -1;
            height = -1;
            try (ImageInputStream in = ImageIO.createImageInputStream(stream);){
                Iterator<ImageReader> readers = ImageIO.getImageReaders(in);
                if (!readers.hasNext()) break block15;
                ImageReader reader = readers.next();
                try {
                    reader.setInput(in);
                    width = reader.getWidth(0);
                    height = reader.getHeight(0);
                }
                finally {
                    reader.dispose();
                }
            }
        }
        return new Dimension(width, height);
    }

    private static class Dimension {
        private final int height;
        private final int width;

        public Dimension(int width, int height) {
            this.width = width;
            this.height = height;
        }
    }

    private static class ReusableInputStream
    extends BufferedInputStream {
        ReusableInputStream(InputStream in) {
            super(in);
            this.mark(Integer.MAX_VALUE);
        }

        @Override
        public void close() {
        }

        public void realClose() {
            try {
                super.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

