/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.rules.doc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.doc.VersioningCopyHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.business.service.archetype.helper.DefaultIMObjectCopyHandler;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopier;
import org.openvpms.component.business.service.archetype.helper.IMObjectCopyHandler;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;

public class DocumentRules {
    public static final String VERSIONS = "versions";
    private final ArchetypeService service;

    public DocumentRules(ArchetypeService service) {
        this.service = service;
    }

    public boolean supportsVersions(DocumentAct act) {
        return this.service.getBean((IMObject)act).hasNode(VERSIONS);
    }

    public List<IMObject> addDocument(DocumentAct act, org.openvpms.component.model.document.Document document) {
        return this.addDocument(act, document, true);
    }

    public List<IMObject> addDocument(DocumentAct act, org.openvpms.component.model.document.Document document, boolean version) {
        DocumentAct oldVersion;
        ArrayList<IMObject> objects = new ArrayList<IMObject>();
        objects.add((IMObject)act);
        if (version && act.getDocument() != null && (oldVersion = this.createVersion(act)) != null) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            ActRelationship relationship = (ActRelationship)bean.addTarget(VERSIONS, (IMObject)oldVersion);
            oldVersion.addActRelationship(relationship);
            objects.add((IMObject)oldVersion);
        }
        act.setDocument(document.getObjectReference());
        act.setFileName(document.getName());
        act.setMimeType(document.getMimeType());
        act.setName(document.getName());
        if (document.isNew()) {
            objects.add((IMObject)document);
        }
        return objects;
    }

    public DocumentAct createVersion(DocumentAct source) {
        DocumentAct result = null;
        Reference existing = source.getDocument();
        if (existing != null && this.supportsVersions(source)) {
            VersioningCopyHandler handler = new VersioningCopyHandler((Act)source, this.service);
            IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)handler, this.service);
            List objects = copier.apply((IMObject)source);
            result = (DocumentAct)objects.get(0);
        }
        return result;
    }

    public boolean isDuplicate(DocumentAct act, org.openvpms.component.model.document.Document document) {
        boolean result = false;
        Reference reference = act.getDocument();
        if (reference != null && document.getSize() != 0 && document.getChecksum() != 0L) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createTupleQuery();
            Root root = query.from(org.openvpms.component.model.document.Document.class, new String[]{reference.getArchetype()}).alias("doc");
            query.multiselect(new Selection[]{root.get("size"), root.get("checksum")});
            query.where((Expression)builder.equal((Expression)root.get("id"), (Object)reference.getId()));
            Tuple tuple = (Tuple)this.service.createQuery(query).getFirstResult();
            if (tuple != null) {
                Integer size = (Integer)tuple.get(0, Integer.class);
                Long checksum = (Long)tuple.get(1, Long.class);
                if (size != null && checksum != null && size != 0 && checksum != 0L && size.intValue() == document.getSize() && checksum.longValue() == document.getChecksum()) {
                    result = true;
                }
            }
        }
        return result;
    }

    public List<DocumentAct> getVersions(DocumentAct act) {
        IMObjectBean bean = this.service.getBean((IMObject)act);
        if (bean.hasNode(VERSIONS)) {
            return bean.getTargets(VERSIONS, DocumentAct.class);
        }
        return Collections.emptyList();
    }

    public DocumentAct getLogo(Entity entity) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(DocumentAct.class);
        Root root = query.from(DocumentAct.class, new String[]{"act.documentLogo"});
        Join owner = root.join("owner").join("entity", entity.getArchetype());
        owner.on((Expression)builder.equal((Expression)owner.get("id"), (Object)entity.getId()));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        return (DocumentAct)this.service.createQuery(query).getFirstResult();
    }

    public org.openvpms.component.model.document.Document copy(org.openvpms.component.model.document.Document document) {
        Document source = (Document)document;
        IMObjectCopier copier = new IMObjectCopier((IMObjectCopyHandler)new DefaultIMObjectCopyHandler(), this.service);
        List objects = copier.apply((IMObject)document);
        Document result = (Document)objects.get(0);
        result.setContents((byte[])source.getContents().clone());
        return result;
    }
}

