/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.math;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.math.MathRules;

public class MathFunctions {
    public BigDecimal roundAmount(BigDecimal amount) {
        return MathRules.round(amount, 2);
    }

    public BigDecimal round(BigDecimal value, int scale) {
        return MathRules.round(value, scale);
    }

    public BigDecimal pow(BigDecimal value, int exponent) {
        return value.pow(exponent);
    }

    public BigDecimal pow(BigDecimal value, BigDecimal exponent) {
        try {
            return this.pow(value, exponent.intValueExact());
        }
        catch (ArithmeticException overflow) {
            double result = Math.pow(value.doubleValue(), exponent.doubleValue());
            return BigDecimal.valueOf(result);
        }
    }
}

