/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.archetype.function.customer;

import java.util.Collection;
import java.util.function.Predicate;
import org.apache.commons.jxpath.ExpressionContext;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.bean.Predicates;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.jxpath.AbstractObjectFunctions;
import org.openvpms.component.system.common.jxpath.FunctionHelper;

public class CustomerFunctions
extends AbstractObjectFunctions {
    private final ArchetypeService service;
    private static final Policy<Participation> CUSTOMER_PARTICIPATION = Policies.any(Participation.class, (Predicate)Predicates.isA((String[])new String[]{"participation.customer"}));

    public CustomerFunctions(ArchetypeService service) {
        super("customer");
        this.setObject((Object)this);
        this.service = service;
    }

    public Party get(ExpressionContext context) {
        return this.get(context.getContextNodePointer().getValue());
    }

    public Party get(Object object) {
        Party result = null;
        if ((object = FunctionHelper.unwrap((Object)object)) instanceof Party) {
            result = this.getCustomer(object);
        } else if (object instanceof Act) {
            Act act = (Act)object;
            IMObjectBean bean = this.service.getBean((IMObject)act);
            result = (Party)bean.getTarget((Collection)act.getParticipations(), Party.class, CUSTOMER_PARTICIPATION);
        }
        return result;
    }

    private Party getCustomer(Object object) {
        return (Party)FunctionHelper.unwrap((Object)object, Party.class, (String)"party.customerperson");
    }
}

