/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.workflow.osworkflow;

import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.workflow.Workflow;
import com.opensymphony.workflow.basic.BasicWorkflow;
import com.opensymphony.workflow.config.Configuration;
import com.opensymphony.workflow.config.DefaultConfiguration;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.StepDescriptor;
import com.opensymphony.workflow.loader.WorkflowDescriptor;
import com.opensymphony.workflow.query.WorkflowExpressionQuery;
import com.opensymphony.workflow.spi.Step;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.FatalBeanException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.StringUtils;
import org.springmodules.workflow.WorkflowException;
import org.springmodules.workflow.osworkflow.OsWorkflowCallback;
import org.springmodules.workflow.osworkflow.OsWorkflowContextHolder;

public class OsWorkflowTemplate
implements InitializingBean {
    private Configuration configuration = new DefaultConfiguration();
    private Integer initialAction = new Integer(0);
    private String workflowName;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setInitialAction(Integer initialAction) {
        this.initialAction = initialAction;
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public String getWorkflowName() {
        return this.workflowName;
    }

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasText((String)this.workflowName)) {
            throw new FatalBeanException("Property [workflowName] is required.");
        }
    }

    public void initialize() {
        this.initialize(this.initialAction, null);
    }

    public void initialize(Map inputs) {
        this.initialize(this.initialAction, inputs);
    }

    public void initialize(int initialAction) {
        this.initialize(initialAction, null);
    }

    public void initialize(final int initialAction, final Map inputs) {
        this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                long id = workflow.initialize(OsWorkflowTemplate.this.workflowName, initialAction, inputs);
                OsWorkflowTemplate.this.bindInstanceIdToWorkflowContext(id);
                return null;
            }
        });
    }

    public void doAction(int actionId) {
        this.doAction(actionId, null);
    }

    public void doAction(int actionId, Object inputKey, Object inputVal) {
        HashMap<Object, Object> inputs = new HashMap<Object, Object>();
        inputs.put(inputKey, inputVal);
        this.doAction(actionId, inputs);
    }

    public void doAction(final int actionId, final Map inputs) {
        this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                workflow.doAction(OsWorkflowTemplate.this.getInstanceId(), actionId, inputs);
                return null;
            }
        });
    }

    public WorkflowDescriptor getWorkflowDescriptor() {
        return (WorkflowDescriptor)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.getWorkflowDescriptor(OsWorkflowTemplate.this.workflowName);
            }
        });
    }

    public List getHistorySteps() {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.getHistorySteps(OsWorkflowTemplate.this.getInstanceId());
            }
        });
    }

    public List getCurrentSteps() {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.getCurrentSteps(OsWorkflowTemplate.this.getInstanceId());
            }
        });
    }

    public List getHistoryStepDescriptors() {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                List steps = workflow.getHistorySteps(OsWorkflowTemplate.this.getInstanceId());
                return OsWorkflowTemplate.this.convertStepsToStepDescriptors(steps, workflow);
            }
        });
    }

    public List getCurrentStepDescriptors() {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                List steps = workflow.getCurrentSteps(OsWorkflowTemplate.this.getInstanceId());
                return OsWorkflowTemplate.this.convertStepsToStepDescriptors(steps, workflow);
            }
        });
    }

    public int[] getAvailableActions() {
        return this.getAvailableActions(null);
    }

    public int[] getAvailableActions(final Map inputs) {
        return (int[])this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.getAvailableActions(OsWorkflowTemplate.this.getInstanceId(), inputs);
            }
        });
    }

    public List getAvailableActionDescriptors() {
        return this.getAvailableActionDescriptors(null);
    }

    public List getAvailableActionDescriptors(final Map inputs) {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                WorkflowDescriptor descriptor = workflow.getWorkflowDescriptor(OsWorkflowTemplate.this.workflowName);
                int[] availableActions = workflow.getAvailableActions(OsWorkflowTemplate.this.getInstanceId(), inputs);
                ArrayList<ActionDescriptor> actionDescriptors = new ArrayList<ActionDescriptor>(availableActions.length);
                for (int i = 0; i < availableActions.length; ++i) {
                    actionDescriptors.add(descriptor.getAction(availableActions[i]));
                }
                return actionDescriptors;
            }
        });
    }

    public int getEntryState() {
        Integer state = (Integer)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return new Integer(workflow.getEntryState(OsWorkflowTemplate.this.getInstanceId()));
            }
        });
        return state;
    }

    public PropertySet getPropertySet() {
        return (PropertySet)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.getPropertySet(OsWorkflowTemplate.this.getInstanceId());
            }
        });
    }

    public boolean canInitialize(int initialStep) {
        return this.canInitialize(initialStep, null);
    }

    public boolean canInitialize(final int initialStep, final Map inputs) {
        Boolean returnValue = (Boolean)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                boolean canInit = workflow.canInitialize(OsWorkflowTemplate.this.workflowName, initialStep, inputs);
                return canInit ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnValue;
    }

    public boolean canModifyEntryState(final int newState) {
        Boolean returnValue = (Boolean)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                boolean canModify = workflow.canModifyEntryState(OsWorkflowTemplate.this.getInstanceId(), newState);
                return canModify ? Boolean.TRUE : Boolean.FALSE;
            }
        });
        return returnValue;
    }

    public void changeEntryState(final int newState) {
        this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                workflow.changeEntryState(OsWorkflowTemplate.this.getInstanceId(), newState);
                return null;
            }
        });
    }

    public List query(final WorkflowExpressionQuery query) {
        return (List)this.execute(new OsWorkflowCallback(){

            public Object doWithWorkflow(Workflow workflow) throws com.opensymphony.workflow.WorkflowException {
                return workflow.query(query);
            }
        });
    }

    public Object execute(OsWorkflowCallback callback) {
        try {
            Workflow workflow = this.createWorkflow(OsWorkflowContextHolder.getWorkflowContext().getCaller());
            workflow.setConfiguration(this.configuration);
            return callback.doWithWorkflow(workflow);
        }
        catch (com.opensymphony.workflow.WorkflowException ex) {
            throw new WorkflowException("", ex);
        }
    }

    protected Workflow createWorkflow(String caller) throws com.opensymphony.workflow.WorkflowException {
        return new BasicWorkflow(caller);
    }

    protected void bindInstanceIdToWorkflowContext(long id) {
        OsWorkflowContextHolder.getWorkflowContext().setInstanceId(id);
    }

    protected long getInstanceId() {
        return OsWorkflowContextHolder.getWorkflowContext().getInstanceId();
    }

    private List convertStepsToStepDescriptors(List steps, Workflow workflow) {
        WorkflowDescriptor descriptor = workflow.getWorkflowDescriptor(this.workflowName);
        ArrayList<StepDescriptor> stepDescriptors = new ArrayList<StepDescriptor>();
        for (int i = 0; i < steps.size(); ++i) {
            Step step = (Step)steps.get(i);
            stepDescriptors.add(descriptor.getStep(step.getStepId()));
        }
        return Collections.unmodifiableList(stepDescriptors);
    }
}

