/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.hivemind;

import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.Registry;
import org.apache.hivemind.Resource;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.util.ClasspathResource;
import org.apache.hivemind.util.FileResource;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContextException;
import org.springframework.core.io.ClassPathResource;
import org.springframework.util.Assert;

public class RegistryFactoryBean
implements FactoryBean,
InitializingBean,
DisposableBean {
    private static final Log log = LogFactory.getLog((Class)(class$org$springmodules$hivemind$RegistryFactoryBean == null ? (class$org$springmodules$hivemind$RegistryFactoryBean = RegistryFactoryBean.class$("org.springmodules.hivemind.RegistryFactoryBean")) : class$org$springmodules$hivemind$RegistryFactoryBean));
    private Registry registry;
    static /* synthetic */ Class class$org$springmodules$hivemind$RegistryFactoryBean;
    static /* synthetic */ Class class$org$apache$hivemind$Registry;

    public Object getObject() throws Exception {
        return this.registry;
    }

    public Class getObjectType() {
        return class$org$apache$hivemind$Registry == null ? (class$org$apache$hivemind$Registry = RegistryFactoryBean.class$("org.apache.hivemind.Registry")) : class$org$apache$hivemind$Registry;
    }

    public boolean isSingleton() {
        return true;
    }

    private Resource wrapSpringResource(ClassResolver resolver, org.springframework.core.io.Resource configLocation) {
        if (configLocation instanceof ClassPathResource) {
            ClassPathResource classpathConfigLocation = (ClassPathResource)configLocation;
            return new ClasspathResourceAdapter(resolver, classpathConfigLocation);
        }
        return new DefaultResourceAdapter(configLocation);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.registry == null) {
            log.info((Object)"Loading default HiveMind registry.");
            this.registry = RegistryBuilder.constructDefaultRegistry();
        }
        log.info((Object)"Hivemind registry loaded");
    }

    public void setConfigLocations(org.springframework.core.io.Resource[] configLocations) {
        Assert.notNull((Object)configLocations, (String)"configLocations cannot be null");
        RegistryBuilder builder = new RegistryBuilder();
        DefaultClassResolver resolver = new DefaultClassResolver();
        log.info((Object)"Loading standard Hivemind modules");
        builder.processModules((ClassResolver)resolver);
        for (int index = 0; index < configLocations.length; ++index) {
            if (log.isInfoEnabled()) {
                log.info((Object)("Loading module : " + configLocations[index]));
            }
            builder.processModule((ClassResolver)resolver, this.wrapSpringResource((ClassResolver)resolver, configLocations[index]));
        }
        this.registry = builder.constructRegistry(Locale.getDefault());
    }

    public void destroy() throws Exception {
        if (this.registry != null) {
            this.registry.shutdown();
            log.info((Object)"Hivemind registry shutdown");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class ClasspathResourceAdapter
    extends ClasspathResource {
        private ClassResolver classResolver;
        private ClassPathResource resource;

        public ClasspathResourceAdapter(ClassResolver classResolver, ClassPathResource resource) {
            super(classResolver, resource.getFilename());
            this.classResolver = classResolver;
            this.resource = resource;
        }

        public Resource getLocalization(Locale locale) {
            return super.getLocalization(locale);
        }

        public URL getResourceURL() {
            try {
                return this.resource.getURL();
            }
            catch (IOException ex) {
                throw new ApplicationContextException("Error getting the url of the resource [" + this.resource.getDescription() + "]", (Throwable)ex);
            }
        }

        protected Resource newResource(String name) {
            return new ClasspathResourceAdapter(this.classResolver, (ClassPathResource)this.resource.createRelative(name));
        }
    }

    private static class DefaultResourceAdapter
    extends FileResource {
        private org.springframework.core.io.Resource resource;

        public DefaultResourceAdapter(org.springframework.core.io.Resource resource) {
            super(resource.getFilename());
            this.resource = resource;
        }

        public Resource getLocalization(Locale locale) {
            return super.getLocalization(locale);
        }

        public URL getResourceURL() {
            try {
                return this.resource.getURL();
            }
            catch (IOException ex) {
                throw new ApplicationContextException("Error during getting the url of the resource");
            }
        }

        protected Resource newResource(String name) {
            try {
                return new DefaultResourceAdapter(this.resource.createRelative(name));
            }
            catch (IOException ex) {
                throw new ApplicationContextException("Error during creation of a new resource");
            }
        }
    }
}

