/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.util;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.springmodules.cache.regex.Match;
import org.springmodules.cache.regex.Perl5Regex;
import org.springmodules.cache.regex.Regex;

public final class BracketSeparatedPropertiesParser {
    protected static final String REGEX_PATTERN = "([a-zA-Z0-9_]+)=([a-zA-Z0-9_ ,]+)";
    protected static final Regex REGEX = new Perl5Regex("([a-zA-Z0-9_]+)=([a-zA-Z0-9_ ,]+)");

    protected static void addProperty(String unparsedProperty, Properties parsedProperties) {
        Match match = REGEX.match(unparsedProperty);
        boolean matches = match.isSuccessful();
        if (!matches) {
            String message = "The String \"" + unparsedProperty + "\" should match the regular expression pattern \"" + REGEX_PATTERN + "\"";
            throw new IllegalArgumentException(message);
        }
        String[] groups = match.getGroups();
        String key = groups[1].trim();
        String value = groups[2].trim();
        if (parsedProperties.containsKey(key)) {
            String message = "The property \"" + key + "\" is specified more than once";
            throw new IllegalArgumentException(message);
        }
        parsedProperties.setProperty(key, value);
    }

    public static Properties parseProperties(String propertiesAsText) {
        String property;
        if (StringUtils.isEmpty((String)propertiesAsText)) {
            throw new IllegalArgumentException("The String to parse should not be empty");
        }
        if (!propertiesAsText.startsWith("[") || !propertiesAsText.endsWith("]")) {
            throw new IllegalArgumentException("The String '" + propertiesAsText + "' should start with '[' and end with ']");
        }
        Properties properties = new Properties();
        String propertiesToSplit = propertiesAsText.substring(1, propertiesAsText.length() - 1);
        String delimeter = "][";
        int delimeterLength = delimeter.length();
        int currentPosition = 0;
        int delimeterPosition = 0;
        while ((delimeterPosition = propertiesToSplit.indexOf(delimeter, currentPosition)) != -1) {
            property = propertiesToSplit.substring(currentPosition, delimeterPosition);
            BracketSeparatedPropertiesParser.addProperty(property, properties);
            currentPosition = delimeterPosition + delimeterLength;
        }
        if (currentPosition <= propertiesToSplit.length()) {
            property = propertiesToSplit.substring(currentPosition);
            BracketSeparatedPropertiesParser.addProperty(property, properties);
        }
        return properties;
    }
}

