/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.provider.jcs;

import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.IElementAttributes;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.control.group.GroupAttrName;
import org.apache.jcs.engine.control.group.GroupId;
import org.springmodules.cache.CacheWrapperException;
import org.springmodules.cache.EntryRetrievalException;
import org.springmodules.cache.provider.AbstractCacheProfileEditor;
import org.springmodules.cache.provider.AbstractCacheProviderFacadeImpl;
import org.springmodules.cache.provider.CacheProfile;
import org.springmodules.cache.provider.CacheProfileValidator;
import org.springmodules.cache.provider.jcs.JcsProfile;
import org.springmodules.cache.provider.jcs.JcsProfileEditor;
import org.springmodules.cache.provider.jcs.JcsProfileValidator;

public final class JcsFacade
extends AbstractCacheProviderFacadeImpl {
    private static Log logger = LogFactory.getLog((Class)(class$org$springmodules$cache$provider$jcs$JcsFacade == null ? (class$org$springmodules$cache$provider$jcs$JcsFacade = JcsFacade.class$("org.springmodules.cache.provider.jcs.JcsFacade")) : class$org$springmodules$cache$provider$jcs$JcsFacade));
    private CompositeCacheManager cacheManager;
    static /* synthetic */ Class class$org$springmodules$cache$provider$jcs$JcsFacade;

    protected AbstractCacheProfileEditor getCacheProfileEditor() {
        return new JcsProfileEditor();
    }

    protected CacheProfileValidator getCacheProfileValidator() {
        return new JcsProfileValidator();
    }

    protected Serializable getKey(Serializable cacheKey, JcsProfile profile) {
        Serializable key = null;
        String group = profile.getGroup();
        if (StringUtils.isEmpty((String)group)) {
            key = cacheKey;
        } else {
            GroupId groupId = new GroupId(profile.getCacheName(), group);
            GroupAttrName groupAttrName = new GroupAttrName(groupId, (Object)cacheKey);
            key = groupAttrName;
        }
        return key;
    }

    protected void onFlushCache(CacheProfile cacheProfile) {
        JcsProfile profile = (JcsProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            CompositeCache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'onFlushCache(CacheProfile)'. Could not find JCS cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                String cacheGroup = profile.getGroup();
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Method 'onFlushCache(CacheProfile)'. Variable 'cacheGroup': " + cacheGroup));
                }
                if (StringUtils.isEmpty((String)cacheGroup)) {
                    try {
                        cache.removeAll();
                    }
                    catch (Exception exception) {
                        StringBuffer messageBuffer = new StringBuffer(64);
                        messageBuffer.append("Exception thrown when flushing cache. Variable 'cacheProfile': ");
                        messageBuffer.append(cacheProfile);
                        String errorMessage = messageBuffer.toString();
                        logger.error((Object)errorMessage, (Throwable)exception);
                        throw new CacheWrapperException(errorMessage, exception);
                    }
                } else {
                    GroupId groupId = new GroupId(cacheName, cacheGroup);
                    cache.remove((Serializable)groupId);
                }
            }
        }
    }

    protected Object onGetFromCache(Serializable cacheKey, CacheProfile cacheProfile) throws EntryRetrievalException {
        JcsProfile profile = (JcsProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isEmpty((String)cacheName)) {
            throw new EntryRetrievalException("The name of the JCS Cache is empty");
        }
        CompositeCache cache = this.cacheManager.getCache(cacheName);
        if (cache == null) {
            String logMessage = "Method 'onGetFromCache(CacheKey, CacheProfile)'. Could not find JCS cache: " + cacheName;
            logger.info((Object)logMessage);
            throw new EntryRetrievalException("Could not find JCS Cache: " + cacheName);
        }
        Serializable cachedObject = null;
        Serializable key = this.getKey(cacheKey, profile);
        ICacheElement cacheElement = cache.get(key);
        if (cacheElement != null) {
            cachedObject = cacheElement.getVal();
        }
        return cachedObject;
    }

    protected void onPutInCache(Serializable cacheKey, CacheProfile cacheProfile, Object objectToCache) {
        JcsProfile profile = (JcsProfile)cacheProfile;
        String cacheName = profile.getCacheName();
        if (StringUtils.isNotEmpty((String)cacheName)) {
            CompositeCache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'onPutInCache(CacheKey, CacheProfile, Object)'. Could not find JCS cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                Serializable key = this.getKey(cacheKey, profile);
                CacheElement newCacheElement = new CacheElement(cache.getCacheName(), key, objectToCache);
                IElementAttributes elementAttributes = cache.getElementAttributes().copy();
                newCacheElement.setElementAttributes(elementAttributes);
                try {
                    cache.update((ICacheElement)newCacheElement);
                }
                catch (Exception exception) {
                    String errorMessage = "Exception thrown when storing an object in the cache. Variable 'cacheProfile': " + cacheProfile;
                    logger.error((Object)errorMessage, (Throwable)exception);
                    throw new CacheWrapperException(errorMessage, exception);
                }
            }
        }
    }

    public void removeFromCache(Serializable cacheKey, String cacheProfileId) {
        JcsProfile profile;
        String cacheName;
        CacheProfile cacheProfile = super.getCacheProfile(cacheProfileId);
        if (cacheProfile != null && StringUtils.isNotEmpty((String)(cacheName = (profile = (JcsProfile)cacheProfile).getCacheName()))) {
            CompositeCache cache = this.cacheManager.getCache(cacheName);
            if (cache == null) {
                if (logger.isInfoEnabled()) {
                    String logMessage = "Method 'removeFromCache(CacheKey, String)'. Could not find JCS cache: " + cacheName;
                    logger.info((Object)logMessage);
                }
            } else {
                Serializable key = this.getKey(cacheKey, profile);
                cache.remove(key);
            }
        }
    }

    public void setCacheManager(CompositeCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    protected void validateCacheManager() {
        if (null == this.cacheManager) {
            throw new IllegalStateException("The Cache Manager should not be null");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

