/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor.flush;

import java.lang.reflect.Method;
import java.util.Properties;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springmodules.cache.interceptor.flush.CacheFlushAspectSupport;
import org.springmodules.cache.interceptor.flush.CacheFlushAttributeSource;
import org.springmodules.cache.interceptor.flush.FlushCache;
import org.springmodules.cache.interceptor.flush.NameMatchCacheFlushAttributeSource;
import org.springmodules.cache.provider.CacheProviderFacade;

public final class CacheFlushInterceptor
extends CacheFlushAspectSupport
implements MethodInterceptor {
    private CacheProviderFacade cacheProviderFacade;

    protected FlushCache getCacheFlushAttribute(MethodInvocation methodInvocation) {
        Method method = methodInvocation.getMethod();
        Object thisObject = methodInvocation.getThis();
        Class<?> targetClass = thisObject != null ? thisObject.getClass() : null;
        CacheFlushAttributeSource attributeSource = super.getCacheFlushAttributeSource();
        FlushCache attribute = attributeSource.getCacheFlushAttribute(method, targetClass);
        return attribute;
    }

    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        FlushCache attribute = this.getCacheFlushAttribute(methodInvocation);
        if (null == attribute) {
            return methodInvocation.proceed();
        }
        String[] cacheProfileIds = attribute.getCacheProfileIds();
        Object proceedReturnValue = null;
        boolean flushedBeforeExecution = attribute.isFlushBeforeExecution();
        if (flushedBeforeExecution) {
            this.cacheProviderFacade.flushCache(cacheProfileIds);
            proceedReturnValue = methodInvocation.proceed();
        } else {
            proceedReturnValue = methodInvocation.proceed();
            this.cacheProviderFacade.flushCache(cacheProfileIds);
        }
        return proceedReturnValue;
    }

    public void setCacheFlushAttributes(Properties cacheFlushAttributes) {
        NameMatchCacheFlushAttributeSource attributeSource = new NameMatchCacheFlushAttributeSource();
        attributeSource.setProperties(cacheFlushAttributes);
        super.setCacheFlushAttributeSource(attributeSource);
    }

    public final void setCacheProviderFacade(CacheProviderFacade cacheProviderFacade) {
        this.cacheProviderFacade = cacheProviderFacade;
    }
}

