/*
 * Decompiled with CFR 0.152.
 */
package org.springmodules.cache.interceptor;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springmodules.cache.CacheAttribute;
import org.springmodules.cache.util.TextMatcher;

public abstract class AbstractMethodMapCacheAttributeSource {
    protected Log logger = LogFactory.getLog(this.getClass());
    private Map attributeMap = new HashMap();
    private Map registeredMethodMap = new HashMap();

    private void addCacheAttribute(Class targetClass, String targetMethodName, CacheAttribute cacheAttribute) {
        Method method;
        String fullyQualifiedTargetMethodName = targetClass.getName() + '.' + targetMethodName;
        LinkedList<Method> matchingMethods = new LinkedList<Method>();
        Method[] methods = targetClass.getDeclaredMethods();
        int methodCount = methods.length;
        for (int i = 0; i < methodCount; ++i) {
            method = methods[i];
            String methodName = method.getName();
            if (!methodName.equals(targetMethodName) && !this.isMatch(methodName, targetMethodName)) continue;
            matchingMethods.add(method);
        }
        if (matchingMethods.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find any method matching '" + fullyQualifiedTargetMethodName + "'");
        }
        Iterator matchingMethodsIterator = matchingMethods.iterator();
        while (matchingMethodsIterator.hasNext()) {
            method = (Method)matchingMethodsIterator.next();
            String registeredMethodName = (String)this.registeredMethodMap.get(method);
            if (registeredMethodName == null || !registeredMethodName.equals(fullyQualifiedTargetMethodName) && registeredMethodName.length() <= fullyQualifiedTargetMethodName.length()) {
                this.registeredMethodMap.put(method, fullyQualifiedTargetMethodName);
                this.addCacheAttribute(method, cacheAttribute);
                continue;
            }
            if (!this.logger.isDebugEnabled() || registeredMethodName == null) continue;
            this.logger.debug((Object)("Keeping attribute for cached method [" + method + "]: current name '" + fullyQualifiedTargetMethodName + "' is not more specific than '" + registeredMethodName + "'"));
        }
    }

    private void addCacheAttribute(Method method, CacheAttribute cacheAttribute) {
        this.logger.info((Object)("Adding method [" + method + "] with cache attribute [" + cacheAttribute + "]"));
        this.attributeMap.put(method, cacheAttribute);
    }

    protected final void addCacheAttribute(String fullyQualifiedMethodName, CacheAttribute cacheAttribute) {
        int methodSeparatorIndex = fullyQualifiedMethodName.lastIndexOf(".");
        if (methodSeparatorIndex == -1) {
            throw new IllegalArgumentException("'" + fullyQualifiedMethodName + "' is not a fully qualified name");
        }
        String className = fullyQualifiedMethodName.substring(0, methodSeparatorIndex);
        String methodName = fullyQualifiedMethodName.substring(methodSeparatorIndex + 1);
        try {
            Class<?> targetClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
            this.addCacheAttribute(targetClass, methodName, cacheAttribute);
        }
        catch (ClassNotFoundException exception) {
            throw new IllegalArgumentException("Class '" + className + "' not found");
        }
    }

    public final Map getAttributeMap() {
        return Collections.unmodifiableMap(this.attributeMap);
    }

    protected boolean isMatch(String methodName, String mappedName) {
        return TextMatcher.isMatch(methodName, mappedName);
    }
}

