/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.load;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openvpms.etl.load.SymbolicReference;

public class SymbolicReferenceParser {
    private static final Pattern pattern = Pattern.compile("<([^<>]+)>([^<>\\s=]+)(=(\\w+))?");

    private SymbolicReferenceParser() {
    }

    public static SymbolicReference parse(String reference) {
        Matcher matcher = pattern.matcher(reference);
        SymbolicReference result = null;
        if (matcher.find()) {
            if (matcher.start() != 0 || matcher.end() != reference.length()) {
                return null;
            }
            String archetype = matcher.group(1);
            if (matcher.group(3) != null) {
                String name = matcher.group(2);
                String value = matcher.group(4);
                result = new SymbolicReference(archetype, name, value);
            } else {
                String rowId = matcher.group(2);
                result = new SymbolicReference(archetype, rowId);
            }
        }
        return result;
    }
}

