/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import org.codehaus.janino.ClassFileIClass;
import org.codehaus.janino.CompileException;
import org.codehaus.janino.DebuggingInformation;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.FilterWarningHandler;
import org.codehaus.janino.IClass;
import org.codehaus.janino.IClassLoader;
import org.codehaus.janino.Java;
import org.codehaus.janino.Location;
import org.codehaus.janino.Parser;
import org.codehaus.janino.ResourceFinderIClassLoader;
import org.codehaus.janino.Scanner;
import org.codehaus.janino.UnitCompiler;
import org.codehaus.janino.WarningHandler;
import org.codehaus.janino.util.Benchmark;
import org.codehaus.janino.util.ClassFile;
import org.codehaus.janino.util.StringPattern;
import org.codehaus.janino.util.TunnelException;
import org.codehaus.janino.util.enumerator.EnumeratorFormatException;
import org.codehaus.janino.util.resource.JarDirectoriesResourceFinder;
import org.codehaus.janino.util.resource.PathResourceFinder;
import org.codehaus.janino.util.resource.ResourceFinder;

public class Compiler {
    private static final boolean DEBUG = false;
    private static final String[] USAGE = new String[]{"Usage:", "", "  java org.codehaus.janino.Compiler [ <option> ] ... <source-file> ...", "", "Supported <option>s are:", "  -d <output-dir>           Where to save class files", "  -sourcepath <dirlist>     Where to look for other source files", "  -classpath <dirlist>      Where to look for other class files", "  -extdirs <dirlist>        Where to look for other class files", "  -bootclasspath <dirlist>  Where to look for other class files", "  -encoding <encoding>      Encoding of source files, e.g. \"UTF-8\" or \"ISO-8859-1\"", "  -verbose", "  -g                        Generate all debugging info", "  -g:none                   Generate no debugging info", "  -g:{lines,vars,source}    Generate only some debugging info", "  -warn:<pattern-list>      Issue certain warnings; examples:", "    -warn:*                 Enables all warnings", "    -warn:IASF              Only warn against implicit access to static fields", "    -warn:*-IASF            Enables all warnings, except those against implicit", "                            access to static fields", "    -warn:*-IA*+IASF        Enables all warnings, except those against implicit", "                            accesses, but do warn against implicit access to", "                            static fields", "  -rebuild                  Compile all source files, even if the class files", "                            seems up-to-date", "  -help", "", "The default encoding in this environment is \"" + new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding() + "\"."};
    private File optionalDestinationDirectory;
    private String optionalCharacterEncoding;
    private Benchmark benchmark;
    private DebuggingInformation debuggingInformation;
    private WarningHandler warningHandler;
    private boolean rebuild;
    private IClassLoader iClassLoader;
    private final ArrayList parsedCompilationUnits = new ArrayList();
    private boolean storingClassFiles = true;

    public Compiler(ResourceFinder resourceFinder, IClassLoader iClassLoader, File file, String string, boolean bl, DebuggingInformation debuggingInformation, StringPattern[] stringPatternArray, boolean bl2) {
        this.optionalDestinationDirectory = file;
        this.optionalCharacterEncoding = string;
        this.benchmark = new Benchmark(bl);
        this.debuggingInformation = debuggingInformation;
        this.warningHandler = new FilterWarningHandler(stringPatternArray, new WarningHandler(){

            public void handleWarning(String string, String string2, Location location) {
                if (location != null) {
                    System.err.print(String.valueOf(String.valueOf(location)) + ": ");
                }
                System.err.println("Warning " + string + ": " + string2);
            }
        });
        this.rebuild = bl2;
        this.iClassLoader = new CompilerIClassLoader(resourceFinder, iClassLoader);
    }

    public Compiler(File[] fileArray, File[] fileArray2, File[] fileArray3, File[] fileArray4, File file, String string, boolean bl, DebuggingInformation debuggingInformation, StringPattern[] stringPatternArray, boolean bl2) {
        this(new PathResourceFinder(fileArray == null ? fileArray2 : fileArray), Compiler.createJavacLikePathIClassLoader(fileArray4, fileArray3, fileArray2), file, string, bl, debuggingInformation, stringPatternArray, bl2);
        this.benchmark.report("*** JANINO - an embedded compiler for the Java(TM) programming language");
        this.benchmark.report("*** For more information visit http://janino.codehaus.org");
        this.benchmark.report("Source path", fileArray);
        this.benchmark.report("Class path", fileArray2);
        this.benchmark.report("Ext dirs", fileArray3);
        this.benchmark.report("Boot class path", fileArray4);
        this.benchmark.report("Destination directory", file);
        this.benchmark.report("Character encoding", string);
        this.benchmark.report("Verbose", new Boolean(bl));
        this.benchmark.report("Debugging information", debuggingInformation);
        this.benchmark.report("Warning handle patterns", stringPatternArray);
        this.benchmark.report("Rebuild", new Boolean(bl2));
    }

    public boolean compile(File[] fileArray) throws Scanner.ScanException, Parser.ParseException, CompileException, IOException {
        this.benchmark.report("Source files", fileArray);
        final int[] nArray = new int[1];
        UnitCompiler.ErrorHandler errorHandler = new UnitCompiler.ErrorHandler(){

            public void handleError(String string, Location location) throws CompileException {
                if (location != null) {
                    System.err.print(String.valueOf(String.valueOf(location)) + ": ");
                }
                System.err.println("Error: " + string);
                this.setStoringClassFiles(false);
                nArray[0] = nArray[0] + 1;
                if (nArray[0] >= 20) {
                    throw new CompileException("Too many compile errors", null);
                }
            }
        };
        this.benchmark.beginReporting();
        try {
            this.parsedCompilationUnits.clear();
            int n = 0;
            while (n < fileArray.length) {
                this.parsedCompilationUnits.add(new UnitCompiler(this.parseCompilationUnit(fileArray[n].getPath(), new BufferedInputStream(new FileInputStream(fileArray[n])), this.optionalCharacterEncoding), this.iClassLoader));
                ++n;
            }
            int n2 = 0;
            while (n2 < this.parsedCompilationUnits.size()) {
                Object var13_10;
                ClassFile[] classFileArray;
                UnitCompiler unitCompiler = (UnitCompiler)this.parsedCompilationUnits.get(n2);
                Java.CompilationUnit compilationUnit = unitCompiler.compilationUnit;
                File file = new File(compilationUnit.getFileName());
                unitCompiler.setCompileErrorHandler(errorHandler);
                unitCompiler.setWarningHandler(this.warningHandler);
                this.benchmark.beginReporting("Compiling compilation unit \"" + file + "\"");
                try {
                    try {
                        classFileArray = unitCompiler.compileUnit(this.debuggingInformation);
                    }
                    catch (TunnelException tunnelException) {
                        Throwable throwable = tunnelException.getDelegate();
                        if (throwable instanceof Scanner.ScanException) {
                            throw (Scanner.ScanException)throwable;
                        }
                        if (throwable instanceof Parser.ParseException) {
                            throw (Parser.ParseException)throwable;
                        }
                        if (throwable instanceof IOException) {
                            throw (IOException)throwable;
                        }
                        throw tunnelException;
                    }
                    var13_10 = null;
                    this.benchmark.endReporting();
                }
                catch (Throwable throwable) {
                    var13_10 = null;
                    this.benchmark.endReporting();
                    throw throwable;
                }
                if (this.storingClassFiles) {
                    this.benchmark.beginReporting("Storing " + classFileArray.length + " class file(s) resulting from compilation unit \"" + file + "\"");
                    try {
                        int n3 = 0;
                        while (n3 < classFileArray.length) {
                            Compiler.storeClassFile(classFileArray[n3], file, this.optionalDestinationDirectory);
                            ++n3;
                        }
                    }
                    finally {
                        var13_10 = null;
                        this.benchmark.endReporting();
                    }
                } else {
                    this.benchmark.report("Not storing " + classFileArray.length + " class files resulting from compilation unit \"" + file + "\"");
                }
                ++n2;
            }
        }
        finally {
            Object var5_16 = null;
            this.benchmark.endReporting("Compiled " + this.parsedCompilationUnits.size() + " compilation unit(s)");
        }
        return nArray[0] == 0;
    }

    private static IClassLoader createJavacLikePathIClassLoader(File[] fileArray, File[] fileArray2, File[] fileArray3) {
        PathResourceFinder pathResourceFinder = new PathResourceFinder(fileArray == null ? PathResourceFinder.parsePath(System.getProperty("sun.boot.class.path")) : fileArray);
        JarDirectoriesResourceFinder jarDirectoriesResourceFinder = new JarDirectoriesResourceFinder(fileArray2 == null ? PathResourceFinder.parsePath(System.getProperty("java.ext.dirs")) : fileArray2);
        PathResourceFinder pathResourceFinder2 = new PathResourceFinder(fileArray3);
        ResourceFinderIClassLoader resourceFinderIClassLoader = new ResourceFinderIClassLoader(pathResourceFinder, null);
        resourceFinderIClassLoader = new ResourceFinderIClassLoader(jarDirectoriesResourceFinder, resourceFinderIClassLoader);
        resourceFinderIClassLoader = new ResourceFinderIClassLoader(pathResourceFinder2, resourceFinderIClassLoader);
        return resourceFinderIClassLoader;
    }

    public static File getClassFile(String string, File file, File file2) {
        if (file2 != null) {
            return new File(file2, String.valueOf(string.replace('.', File.separatorChar)) + ".class");
        }
        int n = string.lastIndexOf(46);
        return new File(file.getParentFile(), String.valueOf(string.substring(n + 1)) + ".class");
    }

    public static void main(String[] stringArray) {
        int n;
        File[] fileArray;
        File file = null;
        File[] fileArray2 = null;
        File[] fileArray3 = new File[]{new File(".")};
        File[] fileArray4 = null;
        File[] fileArray5 = null;
        String string = null;
        boolean bl = false;
        DebuggingInformation debuggingInformation = DebuggingInformation.LINES.add(DebuggingInformation.SOURCE);
        StringPattern[] stringPatternArray = null;
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            fileArray = stringArray[n2];
            if (fileArray.charAt(0) != '-') break;
            if (fileArray.equals("-d")) {
                file = new File(stringArray[++n2]);
            } else if (fileArray.equals("-sourcepath")) {
                fileArray2 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-classpath")) {
                fileArray3 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-extdirs")) {
                fileArray4 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-bootclasspath")) {
                fileArray5 = PathResourceFinder.parsePath(stringArray[++n2]);
            } else if (fileArray.equals("-encoding")) {
                string = stringArray[++n2];
            } else if (fileArray.equals("-verbose")) {
                bl = true;
            } else if (fileArray.equals("-g")) {
                debuggingInformation = DebuggingInformation.ALL;
            } else if (fileArray.startsWith("-g:")) {
                try {
                    debuggingInformation = new DebuggingInformation(fileArray.substring(3).toUpperCase());
                }
                catch (EnumeratorFormatException enumeratorFormatException) {
                    System.err.println("Invalid debugging option \"" + (String)fileArray + "\"");
                    System.exit(1);
                }
            } else if (fileArray.startsWith("-warn:")) {
                stringPatternArray = StringPattern.parseCombinedPattern(fileArray.substring(6));
            } else if (fileArray.equals("-rebuild")) {
                bl2 = true;
            } else if (fileArray.equals("-help")) {
                n = 0;
                while (n < USAGE.length) {
                    System.out.println(USAGE[n]);
                    ++n;
                }
                System.exit(1);
            } else {
                System.err.println("Unrecognized command line option \"" + (String)fileArray + "\"; try \"-help\".");
                System.exit(1);
            }
            ++n2;
        }
        if (n2 == stringArray.length) {
            System.err.println("No source files given on command line; try \"-help\".");
            System.exit(1);
        }
        fileArray = new File[stringArray.length - n2];
        n = n2;
        while (n < stringArray.length) {
            fileArray[n - n2] = new File(stringArray[n]);
            ++n;
        }
        Compiler compiler = new Compiler(fileArray2, fileArray3, fileArray4, fileArray5, file, string, bl, debuggingInformation, stringPatternArray, bl2);
        try {
            if (!compiler.compile(fileArray)) {
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println(exception.toString());
            System.exit(1);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Java.CompilationUnit parseCompilationUnit(String string, InputStream inputStream, String string2) throws Scanner.ScanException, Parser.ParseException, IOException {
        Java.CompilationUnit compilationUnit;
        Scanner scanner = new Scanner(string, inputStream, string2);
        try {
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.warningHandler);
            this.benchmark.beginReporting("Parsing \"" + string + "\"");
            try {
                compilationUnit = parser.parseCompilationUnit();
                Object var10_7 = null;
                this.benchmark.endReporting();
            }
            catch (Throwable throwable) {
                Object var10_8 = null;
                this.benchmark.endReporting();
                throw throwable;
            }
            Object var7_9 = null;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            scanner.close();
            throw throwable;
        }
        scanner.close();
        return compilationUnit;
    }

    public void setStoringClassFiles(boolean bl) {
        this.storingClassFiles = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void storeClassFile(ClassFile classFile, File file, File file2) throws IOException {
        File file3 = Compiler.getClassFile(classFile.getThisClassName(), file, file2);
        File file4 = file3.getParentFile();
        if (file4 != null && !file4.isDirectory() && !file4.mkdirs()) {
            throw new IOException("Cannot create directory for class file \"" + file3 + "\"");
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file3));
        try {
            try {
                classFile.store(bufferedOutputStream);
            }
            catch (IOException iOException) {
                try {
                    ((OutputStream)bufferedOutputStream).close();
                }
                catch (IOException iOException2) {}
                bufferedOutputStream = null;
                if (file3.delete()) throw iOException;
                throw new IOException("Could not delete incompletely written class file \"" + file3 + "\"");
            }
            Object var7_7 = null;
            if (bufferedOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (bufferedOutputStream == null) throw throwable;
            try {
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)bufferedOutputStream).close();
            return;
        }
        catch (IOException iOException) {}
    }

    private class CompilerIClassLoader
    extends IClassLoader {
        private final ResourceFinder sourceFinder;

        public CompilerIClassLoader(ResourceFinder resourceFinder, IClassLoader iClassLoader) {
            super(iClassLoader);
            this.sourceFinder = resourceFinder;
            super.postConstruct();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IClass defineIClassFromClassFile(File file) {
            Compiler.this.benchmark.beginReporting("Loading class file \"" + file + "\"");
            try {
                ClassFile classFile;
                block11: {
                    InputStream inputStream = null;
                    try {
                        try {
                            classFile = new ClassFile(new BufferedInputStream(new FileInputStream(file)));
                        }
                        catch (IOException iOException) {
                            throw new TunnelException(iOException);
                        }
                        Object var8_5 = null;
                        if (inputStream == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var8_6 = null;
                        if (inputStream == null) throw throwable;
                        try {
                            inputStream.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {}
                    catch (IOException iOException) {}
                    inputStream.close();
                }
                ClassFileIClass classFileIClass = new ClassFileIClass(classFile, this);
                this.defineIClass(classFileIClass);
                try {
                    classFileIClass.resolveAllClasses();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new RuntimeException("Could not resolve class \"" + classNotFoundException.getMessage() + "\"");
                }
                ClassFileIClass classFileIClass2 = classFileIClass;
                Object var4_11 = null;
                Compiler.this.benchmark.endReporting();
                return classFileIClass2;
            }
            catch (Throwable throwable) {
                Object var4_12 = null;
                Compiler.this.benchmark.endReporting();
                throw throwable;
            }
        }

        private IClass defineIClassFromSourceFile(File file, String string) throws TunnelException {
            Java.CompilationUnit compilationUnit;
            try {
                compilationUnit = Compiler.this.parseCompilationUnit(file.getPath(), new BufferedInputStream(new FileInputStream(file)), Compiler.this.optionalCharacterEncoding);
            }
            catch (IOException iOException) {
                throw new TunnelException(iOException);
            }
            catch (Parser.ParseException parseException) {
                throw new TunnelException(parseException);
            }
            catch (Scanner.ScanException scanException) {
                throw new TunnelException(scanException);
            }
            UnitCompiler unitCompiler = new UnitCompiler(compilationUnit, Compiler.this.iClassLoader);
            Compiler.this.parsedCompilationUnits.add(unitCompiler);
            IClass iClass = unitCompiler.findClass(string);
            if (iClass == null) {
                return null;
            }
            this.defineIClass(iClass);
            return iClass;
        }

        protected IClass findIClass(String string) throws TunnelException {
            Object object;
            Object object2;
            String string2 = Descriptor.toClassName(string);
            if (string2.startsWith("java.")) {
                return null;
            }
            int n = 0;
            while (n < Compiler.this.parsedCompilationUnits.size()) {
                object2 = (UnitCompiler)Compiler.this.parsedCompilationUnits.get(n);
                object = ((UnitCompiler)object2).findClass(string2);
                if (object != null) {
                    this.defineIClass((IClass)object);
                    return object;
                }
                ++n;
            }
            object = this.sourceFinder.findResource(ClassFile.getSourceResourceName(string2));
            if (object == null) {
                return null;
            }
            if (!(object instanceof ResourceFinder.FileResource)) {
                throw new RuntimeException();
            }
            object2 = ((ResourceFinder.FileResource)object).getFile();
            if (Compiler.this.rebuild) {
                return this.defineIClassFromSourceFile((File)object2, string2);
            }
            long l = 0L;
            l = ((File)object2).lastModified();
            if (l == 0L) {
                throw new RuntimeException();
            }
            File file = Compiler.getClassFile(string2, (File)object2, Compiler.this.optionalDestinationDirectory);
            long l2 = file.lastModified();
            if (l > l2) {
                return this.defineIClassFromSourceFile((File)object2, string2);
            }
            return this.defineIClassFromClassFile(file);
        }
    }
}

