/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.resources.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.resources.Message;
import org.apache.commons.resources.MessageList;

public class BasicMessageList
implements Serializable,
MessageList {
    private static final Comparator actionItemComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((MessageItem)o1).getOrder() - ((MessageItem)o2).getOrder();
        }
    };
    private boolean accessed = false;
    protected Map messages = new HashMap();
    private int count = 0;
    private String globalMessageKey = "org.apache.commons.resources.GLOBAL_MESSAGE";

    public BasicMessageList() {
    }

    public BasicMessageList(String globalMessageKey) {
        this.setGlobalMessageKey(globalMessageKey);
    }

    public BasicMessageList(MessageList messages) {
        this.add(messages);
    }

    public BasicMessageList(String globalMessageKey, MessageList messages) {
        this.setGlobalMessageKey(globalMessageKey);
        this.add(messages);
    }

    public String getGlobalMessageKey() {
        return this.globalMessageKey;
    }

    public void setGlobalMessageKey(String globalMessageKey) {
        this.globalMessageKey = globalMessageKey;
    }

    public void add(String property, Message message) {
        MessageItem item = (MessageItem)this.messages.get(property);
        ArrayList<Message> list = null;
        if (item == null) {
            list = new ArrayList<Message>();
            item = new MessageItem(list, this.count++);
            this.messages.put(property, item);
        } else {
            list = item.getList();
        }
        list.add(message);
    }

    public void add(Message message) {
        this.add(this.getGlobalMessageKey(), message);
    }

    public void add(MessageList messageList) {
        Iterator props = messageList.properties();
        while (props.hasNext()) {
            String property = (String)props.next();
            Iterator msgs = messageList.get(property);
            while (msgs.hasNext()) {
                Message msg = (Message)msgs.next();
                this.add(property, msg);
            }
        }
    }

    public void clear() {
        this.messages.clear();
    }

    public boolean isAccessed() {
        return this.accessed;
    }

    public boolean isEmpty() {
        return this.messages.isEmpty();
    }

    public Iterator get() {
        this.accessed = true;
        if (this.messages.isEmpty()) {
            return Collections.EMPTY_LIST.iterator();
        }
        ArrayList results = new ArrayList();
        ArrayList actionItems = new ArrayList();
        Iterator<Object> i = this.messages.values().iterator();
        while (i.hasNext()) {
            actionItems.add(i.next());
        }
        Collections.sort(actionItems, actionItemComparator);
        i = actionItems.iterator();
        while (i.hasNext()) {
            MessageItem ami = (MessageItem)i.next();
            Iterator msgs = ami.getList().iterator();
            while (msgs.hasNext()) {
                results.add(msgs.next());
            }
        }
        return results.iterator();
    }

    public Iterator get(String property) {
        this.accessed = true;
        MessageItem item = (MessageItem)this.messages.get(property);
        return item == null ? Collections.EMPTY_LIST.iterator() : item.getList().iterator();
    }

    public Iterator properties() {
        return this.messages.keySet().iterator();
    }

    public int size() {
        int total = 0;
        Iterator i = this.messages.values().iterator();
        while (i.hasNext()) {
            MessageItem ami = (MessageItem)i.next();
            total += ami.getList().size();
        }
        return total;
    }

    public int size(String property) {
        MessageItem ami = (MessageItem)this.messages.get(property);
        return ami == null ? 0 : ami.getList().size();
    }

    public String toString() {
        return this.messages.toString();
    }

    protected static class MessageItem
    implements Serializable {
        private List list = null;
        private int order = 0;

        public MessageItem(List list, int order) {
            this.list = list;
            this.order = order;
        }

        public List getList() {
            return this.list;
        }

        public void setList(List list) {
            this.list = list;
        }

        public int getOrder() {
            return this.order;
        }

        public void setOrder(int order) {
            this.order = order;
        }
    }
}

