/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.data.loader;

import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.tools.data.loader.LoadCache;

class LoadContext {
    private final IArchetypeService service;
    private final LoadCache cache;
    private final boolean validateOnly;

    public LoadContext(IArchetypeService service, LoadCache cache, boolean validateOnly) {
        this.service = service;
        this.cache = cache;
        this.validateOnly = validateOnly;
    }

    public IArchetypeService getService() {
        return this.service;
    }

    public IMObjectReference getReference(String id) {
        return this.cache.getReference(id);
    }

    public IMObject getObject(String id) {
        IMObjectReference ref = this.getReference(id);
        IMObject object = null;
        if (ref != null && (object = this.cache.get(ref)) == null) {
            if (this.validateOnly) {
                object = this.service.create(ref.getArchetypeId());
            } else if (!ref.isNew()) {
                object = this.service.get(ref);
            }
        }
        return object;
    }

    public LoadCache getCache() {
        return this.cache;
    }

    public boolean validateOnly() {
        return this.validateOnly;
    }
}

