/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.tools.data.loader;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.ReferenceMap;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.tools.data.loader.ArchetypeDataLoaderException;

class LoadCache {
    private Map<String, IMObjectReference> refs = new HashMap<String, IMObjectReference>();
    private Map<IMObjectReference, String> ids = new HashMap<IMObjectReference, String>();
    private ReferenceMap objects = new ReferenceMap(0, 2);

    LoadCache() {
    }

    public IMObject get(IMObjectReference reference) {
        IMObject result = (IMObject)this.objects.get((Object)reference);
        if (result == null && this.objects.containsKey((Object)reference)) {
            this.objects.remove((Object)reference);
        }
        return result;
    }

    public void add(IMObject object, String id) {
        IMObjectReference ref = object.getObjectReference();
        if (id != null) {
            id = LoadCache.stripPrefix(id);
            this.ids.put(ref, id);
            this.refs.put(id, ref);
        }
        this.objects.put((Object)object.getObjectReference(), (Object)object);
    }

    public Map<String, IMObjectReference> getReferences() {
        return this.refs;
    }

    public void update(IMObjectReference reference) {
        String id = this.ids.get(reference);
        if (id != null) {
            this.ids.put(reference, id);
            this.refs.put(id, reference);
        }
    }

    public IMObjectReference getReference(String id) {
        return this.refs.get(LoadCache.stripPrefix(id));
    }

    public String getId(IMObjectReference reference) {
        return this.ids.get(reference);
    }

    public static String stripPrefix(String id) {
        if (id.startsWith("id:")) {
            id = id.substring("id:".length());
        }
        if (id.length() == 0) {
            throw new ArchetypeDataLoaderException(ArchetypeDataLoaderException.ErrorCode.NullReference);
        }
        return id;
    }
}

