/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.Arrays;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.FromImpl;
import org.openvpms.component.system.common.query.criteria.PathImpl;
import org.openvpms.component.system.common.query.criteria.PredicateImpl;
import org.openvpms.component.system.common.query.criteria.Type;

public class JoinImpl<Z extends IMObject, X extends IMObject>
extends FromImpl<Z, X>
implements Join<Z, X> {
    private final JoinType joinType;
    private Expression<Boolean> expression;

    public JoinImpl(Type<X> type, PathImpl<?> parent, Context context, JoinType joinType) {
        super(type, parent, context);
        this.joinType = joinType;
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public Join<Z, X> on(Expression<Boolean> expression) {
        this.expression = expression;
        return this;
    }

    public Join<Z, X> on(Predicate ... predicates) {
        this.expression = new PredicateImpl(this.getContext(), Arrays.asList(predicates), Predicate.BooleanOperator.AND);
        return this;
    }

    public Join<Z, X> alias(String alias) {
        super.alias(alias);
        return this;
    }

    public Expression<Boolean> getExpression() {
        return this.expression;
    }

    public static enum JoinType {
        INNER,
        LEFT;

    }
}

