/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.system.common.query.criteria;

import java.util.Arrays;
import javax.persistence.Tuple;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Subquery;
import org.openvpms.component.system.common.query.criteria.AggregateExpression;
import org.openvpms.component.system.common.query.criteria.BetweenPredicate;
import org.openvpms.component.system.common.query.criteria.ComparisonPredicate;
import org.openvpms.component.system.common.query.criteria.Context;
import org.openvpms.component.system.common.query.criteria.CriteriaQueryImpl;
import org.openvpms.component.system.common.query.criteria.ExistsPredicate;
import org.openvpms.component.system.common.query.criteria.ExpressionImpl;
import org.openvpms.component.system.common.query.criteria.NullPredicate;
import org.openvpms.component.system.common.query.criteria.OrderImpl;
import org.openvpms.component.system.common.query.criteria.PredicateImpl;
import org.openvpms.component.system.common.query.criteria.Type;

public class CriteriaBuilderImpl
implements CriteriaBuilder {
    private final Context context;

    public CriteriaBuilderImpl(IArchetypeDescriptorCache cache) {
        this.context = new Context(cache);
    }

    public <T> CriteriaQuery<T> createQuery(Class<T> type) {
        return new CriteriaQueryImpl<T>(type, this.context);
    }

    public CriteriaQuery<Tuple> createTupleQuery() {
        return new CriteriaQueryImpl<Tuple>(Tuple.class, this.context);
    }

    public Expression<Long> count(Expression<?> expression) {
        return new AggregateExpression<Long>(Type.LONG, this.context, AggregateExpression.Function.COUNT, expression);
    }

    public Expression<Long> countDistinct(Expression<?> expression) {
        return new AggregateExpression<Long>(Type.LONG, this.context, AggregateExpression.Function.COUNT_DISTINCT, expression);
    }

    public Predicate exists(Subquery<?> subquery) {
        return new ExistsPredicate(this.context, subquery);
    }

    public Predicate and(Expression<Boolean> x, Expression<Boolean> y) {
        return new PredicateImpl(this.context, Arrays.asList(x, y), Predicate.BooleanOperator.AND);
    }

    public Predicate and(Predicate ... predicates) {
        return new PredicateImpl(this.context, Arrays.asList(predicates), Predicate.BooleanOperator.AND);
    }

    public Predicate or(Expression<Boolean> x, Expression<Boolean> y) {
        return new PredicateImpl(this.context, Arrays.asList(x, y), Predicate.BooleanOperator.OR);
    }

    public Predicate or(Predicate ... predicates) {
        return new PredicateImpl(this.context, Arrays.asList(predicates), Predicate.BooleanOperator.OR);
    }

    public Predicate isNull(Expression<?> x) {
        return new NullPredicate(this.context, x);
    }

    public Predicate isNotNull(Expression<?> x) {
        return new NullPredicate(this.context, x, true);
    }

    public Predicate equal(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.EQ);
    }

    public Predicate equal(Expression<?> x, Object y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.EQ);
    }

    public Predicate notEqual(Expression<?> x, Expression<?> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.NE);
    }

    public Predicate notEqual(Expression<?> x, Object y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.NE);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.GT);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.GT);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.GTE);
    }

    public <Y extends Comparable<? super Y>> Predicate greaterThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.GTE);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.LT);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThan(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.LT);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Expression<? extends Y> y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.LTE);
    }

    public <Y extends Comparable<? super Y>> Predicate lessThanOrEqualTo(Expression<? extends Y> x, Y y) {
        return new ComparisonPredicate(this.context, x, y, ComparisonPredicate.Operator.LTE);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> value, Expression<? extends Y> lower, Expression<? extends Y> upper) {
        return new BetweenPredicate(this.context, value, lower, upper);
    }

    public <Y extends Comparable<? super Y>> Predicate between(Expression<? extends Y> value, Y lower, Y upper) {
        return new BetweenPredicate(this.context, value, lower, upper);
    }

    public Predicate like(Expression<String> x, Expression<String> pattern) {
        return new ComparisonPredicate(this.context, x, pattern, ComparisonPredicate.Operator.LIKE);
    }

    public Predicate like(Expression<String> x, String pattern) {
        return new ComparisonPredicate(this.context, x, pattern, ComparisonPredicate.Operator.LIKE);
    }

    public Order asc(Expression<?> expression) {
        return new OrderImpl(true, expression);
    }

    public Order desc(Expression<?> expression) {
        return new OrderImpl(false, expression);
    }

    public <N extends Number> Expression<N> sum(Expression<?> expression) {
        return this.aggregate(AggregateExpression.Function.SUM, expression);
    }

    public <N extends Number> Expression<N> max(Expression<?> expression) {
        return this.aggregate(AggregateExpression.Function.MAX, expression);
    }

    public <N extends Number> Expression<N> min(Expression<?> expression) {
        return this.aggregate(AggregateExpression.Function.MIN, expression);
    }

    public <X extends Comparable<? super X>> Expression<X> greatest(Expression<?> expression) {
        return this.aggregate(AggregateExpression.Function.GREATEST, expression);
    }

    public <X extends Comparable<? super X>> Expression<X> least(Expression<?> expression) {
        return this.aggregate(AggregateExpression.Function.LEAST, expression);
    }

    private <N> AggregateExpression<N> aggregate(AggregateExpression.Function function, Expression<?> expression) {
        Type type = ((ExpressionImpl)expression).getType();
        return new AggregateExpression(type, this.context, function, expression);
    }
}

