/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.scheduler;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.scheduler.JobRunner;
import org.openvpms.component.business.service.scheduler.SchedulerException;
import org.openvpms.component.business.service.scheduler.SingletonJob;
import org.openvpms.component.business.service.scheduler.StatefulJobRunner;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.quartz.CronScheduleBuilder;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.StatefulJob;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class JobScheduler
implements ApplicationContextAware,
InitializingBean,
DisposableBean {
    public static final String JOB_ARCHETYPE = "entity.job*";
    private final Scheduler scheduler;
    private final IArchetypeService service;
    private final UpdateListener listener;
    private ApplicationContext context;
    private Map<Long, Entity> pending = Collections.synchronizedMap(new HashMap());
    private static final Logger log = LoggerFactory.getLogger(JobScheduler.class);

    public JobScheduler(Scheduler scheduler, IArchetypeService service) {
        this.scheduler = scheduler;
        this.service = service;
        this.listener = new UpdateListener();
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.context = applicationContext;
    }

    public void afterPropertiesSet() {
        this.scheduleJobs();
        this.service.addListener(JOB_ARCHETYPE, this.listener);
    }

    public void destroy() {
        this.service.removeListener(JOB_ARCHETYPE, this.listener);
    }

    public void schedule(Entity configuration) {
        JobConfig config = this.getJobConfig((IMObject)configuration);
        JobDetail job = config.createJobDetail(this.context, this.service);
        Trigger trigger = config.createTrigger();
        try {
            Date date = this.scheduler.scheduleJob(job, trigger);
            if (log.isInfoEnabled()) {
                log.info("Job " + configuration.getName() + " (" + configuration.getId() + ") set to trigger at " + date);
            }
        }
        catch (OpenVPMSException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new SchedulerException(exception);
        }
    }

    public void run(Entity configuration) {
        String name = this.getJobName(configuration);
        if (log.isInfoEnabled()) {
            log.info("Running " + configuration.getName() + " (" + configuration.getId() + ") with job name " + name);
        }
        try {
            this.scheduler.triggerJob(new JobKey(name, "DEFAULT"));
        }
        catch (Throwable exception) {
            throw new SchedulerException(exception);
        }
    }

    public Date getNextRunTime(Entity configuration) {
        Date result = null;
        try {
            String name = this.getJobName(configuration);
            Trigger trigger = this.scheduler.getTrigger(new TriggerKey(name, "DEFAULT"));
            if (trigger != null) {
                result = trigger.getNextFireTime();
            }
        }
        catch (Throwable exception) {
            throw new SchedulerException(exception);
        }
        return result;
    }

    public List<Entity> getJobs(String type) {
        List result;
        if (TypeHelper.matches(type, JOB_ARCHETYPE)) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Entity.class);
            Root root = query.from(Entity.class, new String[]{type});
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
            query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
            result = this.service.createQuery(query).getResultList();
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public String getJobName(Entity configuration) {
        return this.getJobConfig((IMObject)configuration).getJobName();
    }

    protected void scheduleJobs() {
        List<Entity> jobs = this.getJobs(JOB_ARCHETYPE);
        for (Entity job : jobs) {
            try {
                this.schedule(job);
            }
            catch (Throwable exception) {
                log.error(exception.getMessage(), exception);
            }
        }
    }

    private void unschedule(IMObject configuration) {
        String name;
        Entity existing = this.pending.get(configuration.getId());
        String string = name = existing != null ? this.getJobName(existing) : this.getJobName((Entity)configuration);
        if (log.isInfoEnabled()) {
            log.info("Unscheduling " + name + " (" + configuration.getId() + ")");
        }
        try {
            this.scheduler.unscheduleJob(new TriggerKey(name));
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
        this.pending.remove(configuration.getId());
    }

    private void onSaved(IMObject configuration) {
        this.unschedule(configuration);
        if (configuration.isActive()) {
            try {
                this.schedule((Entity)configuration);
            }
            catch (Throwable exception) {
                log.error("Failed to schedule job " + configuration.getName() + " (" + configuration.getId() + "): " + exception.getMessage(), exception);
            }
        }
    }

    private void addPending(IMObject configuration) {
        Entity original;
        if (!configuration.isNew() && !this.pending.containsKey(configuration.getId()) && (original = (Entity)this.service.get(configuration.getObjectReference())) != null) {
            this.pending.put(configuration.getId(), original);
        }
    }

    private void removePending(IMObject configuration) {
        this.pending.remove(configuration.getId());
    }

    private JobConfig getJobConfig(IMObject configuration) {
        return new JobConfig(configuration, this.service);
    }

    private static final class JobConfig {
        private final IMObjectBean config;
        private Class<?> jobClass;

        JobConfig(IMObject config, IArchetypeService service) {
            this(service.getBean(config));
        }

        JobConfig(IMObjectBean config) {
            this.config = config;
        }

        String getJobName() {
            String name;
            Class<?> type = this.getJobClass();
            if (SingletonJob.class.isAssignableFrom(type)) {
                name = "singleton:" + type.getName();
            } else {
                IMObject object = this.config.getObject();
                name = "job:" + object.getId() + ":" + object.getName();
            }
            return name;
        }

        Class<?> getJobClass() {
            if (this.jobClass == null) {
                try {
                    this.jobClass = Class.forName(this.config.getString("class"));
                }
                catch (ClassNotFoundException exception) {
                    throw new SchedulerException(exception);
                }
            }
            return this.jobClass;
        }

        Class<? extends Job> getRunner() {
            return this.disallowConcurrentExecution(this.getJobClass()) ? StatefulJobRunner.class : JobRunner.class;
        }

        boolean disallowConcurrentExecution(Class<?> jobClass) {
            return StatefulJob.class.isAssignableFrom(jobClass) || SingletonJob.class.isAssignableFrom(jobClass) || jobClass.getAnnotation(DisallowConcurrentExecution.class) != null;
        }

        JobDetail createJobDetail(ApplicationContext context, IArchetypeService service) {
            JobDataMap map = new JobDataMap();
            map.put("Configuration", (Object)this.config.getObject());
            map.put("ApplicationContext", (Object)context);
            map.put("ArchetypeService", (Object)service);
            JobBuilder builder = JobBuilder.newJob(this.getRunner());
            builder.withIdentity(this.getJobName(), "DEFAULT").setJobData(map);
            return builder.build();
        }

        Trigger createTrigger() {
            Trigger trigger;
            String jobName = this.getJobName();
            CronScheduleBuilder expression = CronScheduleBuilder.cronSchedule((String)this.config.getString("expression"));
            try {
                TriggerBuilder builder = TriggerBuilder.newTrigger();
                trigger = builder.withIdentity(jobName, "DEFAULT").withSchedule((ScheduleBuilder)expression).forJob(jobName).build();
            }
            catch (Throwable exception) {
                throw new SchedulerException(exception);
            }
            return trigger;
        }
    }

    private class UpdateListener
    extends AbstractArchetypeServiceListener {
        private UpdateListener() {
        }

        @Override
        public void save(IMObject object) {
            JobScheduler.this.addPending(object);
        }

        @Override
        public void saved(IMObject object) {
            JobScheduler.this.onSaved(object);
        }

        @Override
        public void remove(IMObject object) {
            JobScheduler.this.addPending(object);
        }

        @Override
        public void removed(IMObject object) {
            JobScheduler.this.unschedule(object);
        }

        @Override
        public void rollback(IMObject object) {
            JobScheduler.this.removePending(object);
        }
    }
}

