/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.cache;

import org.ehcache.Cache;
import org.ehcache.CacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.ResourceUnit;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.EntryUnit;
import org.ehcache.core.config.store.StoreStatisticsConfiguration;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.spi.loaderwriter.CacheLoaderWriter;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceConfiguration;
import org.openvpms.component.business.service.cache.EhcacheManager;
import org.springframework.beans.factory.DisposableBean;

public abstract class AbstractEhcacheManager
implements EhcacheManager,
DisposableBean {
    private final long defaultMaxElements;
    private final CacheManager cacheManager;

    protected AbstractEhcacheManager(StatisticsService statistics) {
        this(statistics, 100L);
    }

    protected AbstractEhcacheManager(StatisticsService statistics, long defaultMaxElements) {
        this.defaultMaxElements = defaultMaxElements;
        CacheManagerBuilder builder = CacheManagerBuilder.newCacheManagerBuilder();
        if (statistics != null) {
            builder = builder.using((Service)statistics);
        }
        this.cacheManager = builder.build(true);
    }

    @Override
    public <K, V> Cache<K, V> create(String name, Class<K> keyType, Class<V> valueType) {
        return this.create(name, this.getMaxElements(name), keyType, valueType);
    }

    @Override
    public <K, V> Cache<K, V> create(String name, Class<K> keyType, Class<V> valueType, CacheLoaderWriter<K, V> loaderWriter) {
        return this.create(name, this.getMaxElements(name), loaderWriter, keyType, valueType);
    }

    @Override
    public <K, V> Cache<K, V> create(String name, long maxElements, Class<K> keyType, Class<V> valueType) {
        return this.create(name, maxElements, null, keyType, valueType);
    }

    @Override
    public <K, V> void setMaxElements(Cache<K, V> cache, String name, long maxElements) {
        ResourcePools pools = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(maxElements, (ResourceUnit)EntryUnit.ENTRIES).build();
        cache.getRuntimeConfiguration().updateResourcePools(pools);
    }

    public void destroy() {
        this.cacheManager.close();
    }

    protected long getMaxElements(String name) {
        return this.defaultMaxElements;
    }

    protected long getDefaultMaxElements() {
        return this.defaultMaxElements;
    }

    protected <K, V> Cache<K, V> create(String name, long maxElements, CacheLoaderWriter<K, V> loaderWriter, Class<K> keyType, Class<V> valueType) {
        if (maxElements <= 0L) {
            maxElements = this.getDefaultMaxElements();
        }
        ResourcePoolsBuilder heap = ResourcePoolsBuilder.newResourcePoolsBuilder().heap(maxElements, (ResourceUnit)EntryUnit.ENTRIES);
        CacheConfigurationBuilder builder = CacheConfigurationBuilder.newCacheConfigurationBuilder(keyType, valueType, (Builder)heap).add((ServiceConfiguration)new StoreStatisticsConfiguration(true));
        if (loaderWriter != null) {
            builder = builder.withLoaderWriter(loaderWriter);
        }
        return this.cacheManager.createCache(name, (Builder)builder);
    }
}

