/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype.helper.lookup;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.business.domain.archetype.ArchetypeId;
import org.openvpms.component.business.domain.im.datatypes.property.AssertionProperty;
import org.openvpms.component.business.domain.im.datatypes.property.PropertyList;
import org.openvpms.component.business.domain.im.lookup.Lookup;
import org.openvpms.component.business.service.archetype.helper.lookup.AbstractLookupAssertion;
import org.openvpms.component.model.archetype.AssertionDescriptor;
import org.openvpms.component.model.archetype.NamedProperty;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;

class LocalLookup
extends AbstractLookupAssertion {
    public static final String TYPE = "lookup.local";
    private final List<org.openvpms.component.model.lookup.Lookup> lookups = new ArrayList<org.openvpms.component.model.lookup.Lookup>();

    public LocalLookup(AssertionDescriptor assertion, ArchetypeService service, LookupService lookupService) {
        super(assertion, TYPE, service, lookupService);
        PropertyList list = (PropertyList)assertion.getPropertyMap().getProperties().get("entries");
        for (NamedProperty prop : list.getProperties()) {
            AssertionProperty aprop = (AssertionProperty)prop;
            this.lookups.add(new Lookup(ArchetypeId.LOCAL_LOOKUP_ID, aprop.getName(), aprop.getValue()));
        }
    }

    @Override
    public List<org.openvpms.component.model.lookup.Lookup> getLookups() {
        return this.lookups;
    }

    @Override
    public org.openvpms.component.model.lookup.Lookup getLookup(String code) {
        for (org.openvpms.component.model.lookup.Lookup lookup : this.lookups) {
            if (!lookup.getCode().equals(code)) continue;
            return lookup;
        }
        return null;
    }
}

