/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.Collections;
import java.util.List;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.i18n.FrameworkMessages;
import org.openvpms.component.service.archetype.ValidationError;

public class ValidationException
extends OpenVPMSException {
    private final List<ValidationError> errors;
    private static final long serialVersionUID = 2L;

    public ValidationException(String archetype, ValidationError error) {
        this(archetype, Collections.singletonList(error));
    }

    public ValidationException(String archetype, List<ValidationError> errors) {
        super(FrameworkMessages.failedToValidateObject(archetype));
        this.errors = errors;
    }

    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.getMessage()).append("\n");
        for (ValidationError error : this.errors) {
            buf.append("\tnode:").append(error.getNode()).append(" msg:").append(error.getMessage()).append("\n");
        }
        return buf.toString();
    }
}

