/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.service.archetype;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;

class ListenerRegistrations {
    private final Map<Key, Registration> listenerRegistrations = new ConcurrentHashMap<Key, Registration>();
    private final Map<String, Listeners> listeners = new ConcurrentHashMap<String, Listeners>();

    ListenerRegistrations() {
    }

    public void add(String archetype, List<String> matches, IArchetypeServiceListener listener) {
        Registration registration = this.listenerRegistrations.computeIfAbsent(new Key(archetype, listener), key -> new Registration(archetype, listener));
        registration.register(new LinkedHashSet<String>(matches), this.listeners);
    }

    public void remove(String archetype, IArchetypeServiceListener listener) {
        Registration registration = this.listenerRegistrations.remove(new Key(archetype, listener));
        if (registration != null) {
            registration.deregister(this.listeners);
        }
    }

    public void archetypeAdded(String archetype) {
        for (Registration registration : this.listenerRegistrations.values()) {
            registration.archetypeAdded(archetype, this.listeners);
        }
    }

    public IArchetypeServiceListener[] get(String archetype) {
        Listeners result = this.listeners.get(archetype);
        return result != null ? result.get() : null;
    }

    public int getRegistrationCount() {
        return this.listenerRegistrations.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getListenerCount() {
        int result = 0;
        Map<String, Listeners> map = this.listeners;
        synchronized (map) {
            for (Listeners l : this.listeners.values()) {
                result += l.listeners.size();
            }
        }
        return result;
    }

    private static class Listeners {
        private final Set<IArchetypeServiceListener> listeners = new LinkedHashSet<IArchetypeServiceListener>();

        private Listeners() {
        }

        synchronized void add(IArchetypeServiceListener listener) {
            this.listeners.add(listener);
        }

        synchronized void remove(IArchetypeServiceListener listener) {
            this.listeners.remove(listener);
        }

        synchronized IArchetypeServiceListener[] get() {
            IArchetypeServiceListener[] result = this.listeners.toArray(new IArchetypeServiceListener[0]);
            return result.length != 0 ? result : null;
        }
    }

    static class Registration {
        private final String registrationArchetype;
        private final boolean wildcard;
        private final IArchetypeServiceListener listener;
        private Set<String> matches = new HashSet<String>();

        public Registration(String archetype, IArchetypeServiceListener listener) {
            this.registrationArchetype = archetype;
            this.wildcard = archetype.contains("*");
            this.listener = listener;
        }

        public synchronized void register(Set<String> matches, Map<String, Listeners> listeners) {
            for (String match : matches) {
                this.register(match, listeners);
            }
            this.matches = matches;
        }

        public synchronized void deregister(Map<String, Listeners> listeners) {
            for (String match : this.matches) {
                Listeners l = listeners.get(match);
                if (l == null) continue;
                l.remove(this.listener);
            }
            this.matches.clear();
        }

        public synchronized void archetypeAdded(String archetype, Map<String, Listeners> listeners) {
            if (this.matches(archetype)) {
                this.register(archetype, listeners);
                this.matches.add(archetype);
            }
        }

        private boolean matches(String archetype) {
            return this.wildcard ? TypeHelper.isA(archetype, this.registrationArchetype) : this.registrationArchetype.equals(archetype);
        }

        private void register(String archetype, Map<String, Listeners> listeners) {
            Listeners l = listeners.computeIfAbsent(archetype, k -> new Listeners());
            l.add(this.listener);
        }
    }

    static class Key {
        private final String archetype;
        private final IArchetypeServiceListener listener;

        public Key(String archetype, IArchetypeServiceListener listener) {
            this.listener = listener;
            this.archetype = archetype;
        }

        public int hashCode() {
            return Objects.hash(this.listener, this.archetype);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof Key) {
                Key other = (Key)obj;
                return this.listener == other.listener && this.archetype.equals(other.archetype);
            }
            return false;
        }
    }
}

