/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.domain.archetype;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.archetype.ArchetypeIdException;
import org.openvpms.component.business.domain.archetype.ShortName;

class QualifiedName {
    private final ShortName shortName;
    private final String version;
    private final String qualifiedName;
    private static final Map<String, QualifiedName> cache = Collections.synchronizedMap(new ReferenceMap());

    private QualifiedName(ShortName shortName, String version, String qualifiedName) {
        this.shortName = shortName;
        this.version = version;
        this.qualifiedName = qualifiedName;
    }

    public String getShortName() {
        return this.shortName.getShortName();
    }

    public String getVersion() {
        return this.version;
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QualifiedName)) {
            return false;
        }
        QualifiedName rhs = (QualifiedName)obj;
        if (this.shortName.getShortName().equals(rhs.getShortName())) {
            return Objects.equals(this.version, rhs.version);
        }
        return false;
    }

    public int hashCode() {
        int versionHash = this.version != null ? this.version.hashCode() : 0;
        return this.shortName.hashCode() + versionHash;
    }

    public static QualifiedName get(String qname) {
        QualifiedName result = cache.get(qname);
        if (result == null) {
            result = QualifiedName.parse(qname);
            cache.put(qname, result);
        }
        return result;
    }

    private static QualifiedName parse(String qname) {
        if (StringUtils.isEmpty((CharSequence)qname)) {
            throw new ArchetypeIdException(ArchetypeIdException.ErrorCode.EmptyQualifiedName);
        }
        StringTokenizer tokens = new StringTokenizer(qname, ".");
        if (tokens.countTokens() < 2) {
            throw new ArchetypeIdException(ArchetypeIdException.ErrorCode.InvalidQNameFormat, qname);
        }
        String entityName = tokens.nextToken();
        String concept = tokens.nextToken();
        ShortName shortName = ShortName.get(entityName, concept);
        String version = null;
        if (tokens.hasMoreTokens()) {
            StringBuilder buf = new StringBuilder(tokens.nextToken());
            while (tokens.hasMoreTokens()) {
                buf.append(".").append(tokens.nextToken());
            }
            version = buf.toString();
        }
        return new QualifiedName(shortName, version, qname);
    }
}

