/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.openvpms.component.business.dao.hibernate.im.entity.HibernateResultCollector;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.business.service.archetype.descriptor.cache.IArchetypeDescriptorCache;

abstract class AbstractNodeResultCollector<T>
extends HibernateResultCollector<T> {
    private final IArchetypeDescriptorCache cache;
    private final Collection<String> names;

    public AbstractNodeResultCollector(IArchetypeDescriptorCache cache, Collection<String> nodes) {
        this.cache = cache;
        this.names = nodes;
    }

    protected List<NodeDescriptor> getDescriptors(IMObject object) {
        List<NodeDescriptor> result;
        String shortName = object.getArchetype();
        ArchetypeDescriptor archetype = this.cache.getArchetypeDescriptor(shortName);
        if (archetype == null) {
            result = Collections.emptyList();
        } else {
            result = new ArrayList();
            for (String name : this.names) {
                NodeDescriptor node = archetype.getNodeDescriptor(name);
                if (node == null) continue;
                result.add(node);
            }
        }
        return result;
    }

    protected Object loadValue(NodeDescriptor descriptor, IMObject object) {
        Object value = descriptor.getValue(object);
        if (value instanceof Collection) {
            for (Object elt : (Collection)value) {
                if (!(elt instanceof IMObject)) continue;
                this.getLoader().load(elt);
            }
        }
        return value;
    }
}

