/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.component.business.dao.hibernate.im.common;

import org.openvpms.component.business.dao.hibernate.im.common.Assembler;
import org.openvpms.component.business.dao.hibernate.im.common.Context;
import org.openvpms.component.business.dao.hibernate.im.common.DOState;
import org.openvpms.component.business.dao.hibernate.im.common.HibernateHelper;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDO;
import org.openvpms.component.business.dao.hibernate.im.common.IMObjectDOImpl;
import org.openvpms.component.business.dao.im.common.IMObjectDAOException;
import org.openvpms.component.business.domain.im.common.IMObject;
import org.openvpms.component.model.object.Reference;

public class AbstractAssembler {
    protected <T extends IMObject> DOState getDO(T source, Context context) {
        if (source == null) {
            return null;
        }
        DOState state = context.getCached(source);
        if (state == null) {
            Assembler assembler = context.getAssembler();
            state = assembler.assemble(source, context);
        }
        return state;
    }

    protected <DO extends IMObjectDO, T extends IMObject> T getObject(DO source, Class<T> type, Context context) {
        if (source == null) {
            return null;
        }
        IMObject object = context.getCached(source);
        if (object == null) {
            Assembler assembler = context.getAssembler();
            object = assembler.assemble(source, context);
        }
        return (T)((IMObject)type.cast(object));
    }

    protected <DO extends IMObjectDO, Impl extends IMObjectDOImpl> DOState get(Reference reference, Class<DO> type, Class<Impl> impl, Context context) {
        DO result;
        if (reference == null) {
            return null;
        }
        DOState state = context.getCached(reference);
        if (state != null) {
            return state;
        }
        if (reference.getId() != -1L && (result = context.get(reference, type, impl)) != null) {
            return new DOState((IMObjectDO)result);
        }
        return null;
    }

    protected <DO extends IMObjectDO, Impl extends IMObjectDOImpl> DO load(Reference reference, Class<DO> type, Class<Impl> impl, Context context) {
        DOState result = this.get(reference, type, impl, context);
        if (result == null) {
            throw new IMObjectDAOException(IMObjectDAOException.ErrorCode.ObjectNotFound, reference);
        }
        return (DO)((IMObjectDO)type.cast(result.getObject()));
    }

    protected <DO extends IMObjectDO> DO deproxy(DO object) {
        return (DO)((IMObjectDO)HibernateHelper.deproxy(object));
    }
}

