/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.metadata.annotation.java;

import org.drools.spring.metadata.BasicRuleMetadata;
import org.drools.spring.metadata.RuleMetadata;
import org.drools.spring.metadata.RuleMetadataSource;
import org.drools.spring.metadata.annotation.java.Rule;

public class AnnotationRuleMetadataSource
implements RuleMetadataSource {
    public RuleMetadata getRuleMetadata(Class pojoClass) {
        Rule ruleAnnotation = pojoClass.getAnnotation(Rule.class);
        if (ruleAnnotation == null) {
            return null;
        }
        if (this.isAllValuesDefaulted(ruleAnnotation)) {
            return null;
        }
        if (ruleAnnotation.value().length() > 0) {
            return this.createRuleMetadataFromDefaultValue(ruleAnnotation);
        }
        return this.createRuleMetadataFromNamedValues(pojoClass, ruleAnnotation);
    }

    private boolean isAllValuesDefaulted(Rule ruleAnnotation) {
        return ruleAnnotation.value().length() == 0 && ruleAnnotation.value().length() == 0 && ruleAnnotation.name().length() == 0 && ruleAnnotation.documentation().length() == 0 && ruleAnnotation.salience() == Integer.MIN_VALUE && ruleAnnotation.duration() == Long.MIN_VALUE && ruleAnnotation.loop() == Rule.Loop.DEFAULT;
    }

    private RuleMetadata createRuleMetadataFromDefaultValue(Rule ruleAnnotation) {
        BasicRuleMetadata metadata = new BasicRuleMetadata();
        metadata.setName(ruleAnnotation.value());
        return metadata;
    }

    private RuleMetadata createRuleMetadataFromNamedValues(Class pojoClass, Rule ruleAnnotation) {
        BasicRuleMetadata metadata = new BasicRuleMetadata();
        if (ruleAnnotation.name().length() > 0) {
            metadata.setName(ruleAnnotation.name());
        } else {
            metadata.setName(pojoClass.getName());
        }
        if (ruleAnnotation.documentation().length() > 0) {
            metadata.setDocumentation(ruleAnnotation.documentation());
        }
        if (ruleAnnotation.salience() != Integer.MIN_VALUE) {
            metadata.setSalience(ruleAnnotation.salience());
        }
        if (ruleAnnotation.duration() != Long.MIN_VALUE) {
            metadata.setDuration(ruleAnnotation.duration());
        }
        if (ruleAnnotation.loop() != Rule.Loop.DEFAULT) {
            metadata.setNoLoop(ruleAnnotation.loop().getValue());
        }
        return metadata;
    }
}

