/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.sim;

import org.drools.spring.examples.jiahvac.model.Floor;
import org.drools.spring.examples.jiahvac.model.HeatPump;
import org.drools.spring.examples.jiahvac.model.Vent;
import org.drools.spring.examples.jiahvac.sim.SimFloor;
import org.drools.spring.examples.jiahvac.sim.SimHeatPump;
import org.drools.spring.examples.jiahvac.sim.SimThermometer;
import org.drools.spring.examples.jiahvac.sim.SimVent;

public class Simulator
implements Runnable {
    private final double RATE = 0.01;
    private final double HOT = 100.0;
    private final double COLD = 50.0;
    private SimFloor[] floors;
    private SimHeatPump[] heatPumps;
    private double outdoorTempurature = 90.0;

    public Simulator(int numOfFloors, double initialTempuratureReading, Vent.State initialVentState) {
        if (numOfFloors % 3 != 0) {
            throw new RuntimeException("numOfFloors must be divisible by 3");
        }
        this.buildFloors(numOfFloors, initialTempuratureReading, initialVentState);
        this.buildHeatPumps();
        new Thread(this).start();
    }

    private void buildFloors(int numOfFloors, double initialTempuratureReading, Vent.State initialVentState) {
        this.floors = new SimFloor[numOfFloors];
        for (int i = 0; i < numOfFloors; ++i) {
            this.floors[i] = new SimFloor(i);
            SimThermometer thermometer = new SimThermometer(this.floors[i]);
            thermometer.setReading(initialTempuratureReading);
            this.floors[i].setThermometer(thermometer);
            SimVent vent = new SimVent(this.floors[i]);
            vent.setState(initialVentState);
            this.floors[i].setVent(vent);
        }
    }

    private void buildHeatPumps() {
        int numHeatPumps = this.floors.length / 3;
        this.heatPumps = new SimHeatPump[numHeatPumps];
        int floorNumber = 0;
        for (int i = 0; i < numHeatPumps; ++i) {
            Floor[] servicedFloors = new SimFloor[]{this.floors[floorNumber++], this.floors[floorNumber++], this.floors[floorNumber++]};
            this.heatPumps[i] = new SimHeatPump(i, servicedFloors);
            ((SimFloor)servicedFloors[0]).setHeatPump(this.heatPumps[i]);
            ((SimFloor)servicedFloors[1]).setHeatPump(this.heatPumps[i]);
            ((SimFloor)servicedFloors[2]).setHeatPump(this.heatPumps[i]);
        }
    }

    public void run() {
        for (int i = 0; i < this.floors.length; ++i) {
            SimThermometer thermometer = this.floors[i].getThermometer();
            SimVent vent = this.floors[i].getVent();
            SimHeatPump pump = this.floors[i].getHeatPump();
            double temperature = thermometer.getReading();
            temperature += this.leakage(temperature);
            switch (pump.getState()) {
                case HEATING: {
                    temperature += this.heatingTempuratureDelta(vent, temperature);
                    break;
                }
                case COOLING: {
                    temperature += this.coolingTempuratureDelta(vent, temperature);
                    break;
                }
                case OFF: {
                    temperature += this.offTempuratureDelta(i);
                }
            }
            thermometer.setReading(temperature);
        }
    }

    private double coolingTempuratureDelta(Vent vent, double temperature) {
        return (50.0 - temperature) * 0.01 * vent.getState().getValue();
    }

    private double heatingTempuratureDelta(Vent vent, double temperature) {
        return (100.0 - temperature) * 0.01 * vent.getState().getValue();
    }

    private double offTempuratureDelta(int i) {
        return (double)(i + 1) * 0.005;
    }

    private double leakage(double temperature) {
        return (this.outdoorTempurature - temperature) * 0.01 / 2.0;
    }

    public Floor[] getFloors() {
        return this.floors;
    }

    public HeatPump[] getHeatPumps() {
        return this.heatPumps;
    }

    public void setOutdoorTempurature(double tempurature) {
        this.outdoorTempurature = tempurature;
    }

    public double getOutdoorTempurature() {
        return this.outdoorTempurature;
    }
}

