/*
 * Decompiled with CFR 0.152.
 */
package org.drools.spring.examples.jiahvac.control.rules;

import org.drools.spring.examples.jiahvac.model.HeatPump;
import org.drools.spring.examples.jiahvac.model.TempuratureControl;
import org.drools.spring.examples.jiahvac.model.Thermometer;
import org.drools.spring.metadata.annotation.java.Condition;
import org.drools.spring.metadata.annotation.java.Consequence;
import org.drools.spring.metadata.annotation.java.Rule;

@Rule
public class PumpCoolingWhenFloorTooHot {
    private TempuratureControl control;

    public void setControl(TempuratureControl control) {
        this.control = control;
    }

    @Condition
    public boolean isPumpOff(HeatPump pump) {
        return pump.getState() == HeatPump.State.OFF;
    }

    @Condition
    public boolean isPumpServicingFloor(HeatPump pump, Thermometer thermometer) {
        return thermometer.getFloor().getHeatPump() == pump;
    }

    @Condition
    public boolean isTooHot(Thermometer thermometer) {
        return this.control.isTooHot(thermometer.getReading());
    }

    @Consequence
    public void consequence(HeatPump pump) {
        pump.setState(HeatPump.State.COOLING);
        System.out.println("PumpCoolingWhenFloorTooHot: " + pump);
    }
}

