/*
 * Decompiled with CFR 0.152.
 */
package org.drools.smf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.drools.smf.NoSuchSemanticModuleException;
import org.drools.smf.SemanticModule;
import org.drools.smf.SemanticsReader;
import org.drools.smf.SemanticsReaderException;
import org.drools.smf.SemanticsRepository;
import org.drools.smf.SimpleSemanticsRepository;

public final class DefaultSemanticsRepository
implements SemanticsRepository {
    private static SemanticsRepository INSTANCE;
    private ClassLoaderHelper clHelper;
    private Set loadedSemantics = new HashSet();
    private SimpleSemanticsRepository repository = new SimpleSemanticsRepository();

    public static synchronized SemanticsRepository getInstance() throws IOException, SemanticsReaderException {
        if (INSTANCE == null) {
            INSTANCE = new DefaultSemanticsRepository();
        }
        return INSTANCE;
    }

    private DefaultSemanticsRepository() throws IOException, SemanticsReaderException {
        this.init();
    }

    protected void init() throws IOException, SemanticsReaderException {
        Enumeration<URL> configUrls;
        ClassLoaderHelper clh = new CurrentThreadClassLoaderHelper();
        if (clh.getClassLoader() == null) {
            clh = new CurrentClassLoaderHelper();
        }
        if (!(configUrls = clh.getClassLoader().getResources("META-INF/drools.conf")).hasMoreElements()) {
            clh = new CurrentClassLoaderHelper();
            configUrls = clh.getClassLoader().getResources("META-INF/drools.conf");
        }
        if (!configUrls.hasMoreElements()) {
            clh = new SystemClassLoaderHelper();
            configUrls = clh.getClassLoader().getResources("META-INF/drools.conf");
        }
        this.clHelper = clh;
        while (configUrls.hasMoreElements()) {
            URL configUrl = configUrls.nextElement();
            this.loadConfig(configUrl);
        }
        String droolsConfigProp = System.getProperty("drools.conf");
        if (droolsConfigProp != null) {
            this.loadConfig(droolsConfigProp);
        }
    }

    protected void loadConfig(String path) throws IOException, SemanticsReaderException {
        URL url = this.clHelper.getClassLoader().getResource(path);
        if (url == null) {
            System.err.println("INVALID PATH: [" + path + "]");
            return;
        }
        this.loadConfig(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig(URL url) throws IOException, SemanticsReaderException {
        InputStream config = url.openStream();
        BufferedReader in = new BufferedReader(new InputStreamReader(config));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("") || line.startsWith("#")) continue;
                this.loadSemantics(line);
            }
        }
        finally {
            in.close();
        }
    }

    protected void loadSemantics(String semanticsName) throws IOException, SemanticsReaderException {
        if (this.loadedSemantics.contains(semanticsName)) {
            return;
        }
        this.loadedSemantics.add(semanticsName);
        String semanticsFile = "META-INF/" + semanticsName + ".conf";
        URL descriptor = this.clHelper.getClassLoader().getResource(semanticsFile);
        if (descriptor == null) {
            System.err.println("cannot load " + semanticsFile);
            return;
        }
        SemanticsReader semanticsReader = new SemanticsReader();
        SemanticModule module = semanticsReader.read(descriptor, this.clHelper.getClassLoader());
        this.repository.registerSemanticModule(module);
    }

    public SemanticModule lookupSemanticModule(String uri) throws NoSuchSemanticModuleException {
        return this.repository.lookupSemanticModule(uri);
    }

    public SemanticModule[] getSemanticModules() {
        return this.repository.getSemanticModules();
    }

    public ClassLoader getSemanticModuleClassLoader() {
        return this.clHelper.getClassLoader();
    }

    static class SystemClassLoaderHelper
    implements ClassLoaderHelper {
        SystemClassLoaderHelper() {
        }

        public ClassLoader getClassLoader() {
            return ClassLoader.getSystemClassLoader();
        }
    }

    static class CurrentClassLoaderHelper
    implements ClassLoaderHelper {
        CurrentClassLoaderHelper() {
        }

        public ClassLoader getClassLoader() {
            return this.getClass().getClassLoader();
        }
    }

    static class CurrentThreadClassLoaderHelper
    implements ClassLoaderHelper {
        CurrentThreadClassLoaderHelper() {
        }

        public ClassLoader getClassLoader() {
            return Thread.currentThread().getContextClassLoader();
        }
    }

    static interface ClassLoaderHelper {
        public ClassLoader getClassLoader();
    }
}

