/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.rule.ApplicationData;
import org.drools.rule.DuplicateRuleNameException;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.Rule;
import org.drools.spi.Functions;
import org.drools.spi.Importer;
import org.drools.spi.RuleBaseContext;

public class RuleSet
implements Serializable {
    public static final RuleSet[] EMPTY_ARRAY = new RuleSet[0];
    private String name;
    private String documentation;
    private Set ruleNames;
    private List rules;
    private Importer importer;
    private Map applicationData;
    private Map functions;
    private RuleBaseContext ruleBaseContext;

    public RuleSet(String name) {
        this.name = name;
        this.ruleNames = new HashSet();
        this.rules = new ArrayList();
        this.applicationData = new HashMap();
        this.functions = new HashMap();
        this.ruleBaseContext = new RuleBaseContext();
    }

    public RuleSet(String name, RuleBaseContext ruleBaseContext) {
        this.name = name;
        this.ruleNames = new HashSet();
        this.rules = new ArrayList();
        this.applicationData = new HashMap();
        this.functions = new HashMap();
        this.ruleBaseContext = ruleBaseContext;
    }

    public String getName() {
        return this.name;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void addRule(Rule rule) throws DuplicateRuleNameException, InvalidRuleException {
        rule.checkValidity();
        String name = rule.getName();
        if (this.containsRule(name)) {
            throw new DuplicateRuleNameException(this, this.getRule(name), rule);
        }
        this.ruleNames.add(name);
        rule.setLoadOrder(this.rules.size());
        rule.setImporter(this.importer);
        this.rules.add(rule);
    }

    public Rule getRule(String name) {
        Rule[] rules = this.getRules();
        for (int i = 0; i < rules.length; ++i) {
            if (!rules[i].getName().equals(name)) continue;
            return rules[i];
        }
        return null;
    }

    public boolean containsRule(String name) {
        return this.ruleNames.contains(name);
    }

    public Rule[] getRules() {
        return this.rules.toArray(new Rule[this.rules.size()]);
    }

    public Importer getImporter() {
        return this.importer;
    }

    public void setImporter(Importer importer) {
        this.importer = importer;
    }

    public void addApplicationData(ApplicationData applicationData) {
        this.applicationData.put(applicationData.getIdentifier(), applicationData.getType());
    }

    public Map getApplicationData() {
        return this.applicationData;
    }

    public void addFunctions(Functions functions) {
        this.functions.put(functions.getSemantic(), functions);
    }

    public Functions getFunctions(String semantic) {
        return (Functions)this.functions.get(semantic);
    }

    public RuleBaseContext getRuleBaseContext() {
        return this.ruleBaseContext;
    }
}

