/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.fibonacci;

import org.drools.DroolsException;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.RuleBaseBuilder;
import org.drools.WorkingMemory;
import org.drools.examples.fibonacci.Fibonacci;
import org.drools.reteoo.Dumper;
import org.drools.rule.Declaration;
import org.drools.rule.Rule;
import org.drools.rule.RuleSet;
import org.drools.semantics.base.ClassObjectType;
import org.drools.spi.Condition;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Tuple;

public class FibonacciNative {
    public static void main(String[] args) throws DroolsException {
        RuleSet ruleSet = new RuleSet("fibonacci");
        Rule bootstrap1Rule = new Rule("Bootstrap 1");
        bootstrap1Rule.setSalience(20);
        ClassObjectType fibonacciType = new ClassObjectType(Fibonacci.class);
        final Declaration fDeclaration = bootstrap1Rule.addParameterDeclaration("f", fibonacciType);
        Condition conditionBootstrap1A = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration);
                return f.getSequence() == 1;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{fDeclaration};
            }

            public String toString() {
                return "f.getSequence() == 1";
            }
        };
        bootstrap1Rule.addCondition(conditionBootstrap1A);
        Condition conditionBootstrap1B = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration);
                return f.getValue() == -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{fDeclaration};
            }

            public String toString() {
                return "f.getValue() == -1";
            }
        };
        bootstrap1Rule.addCondition(conditionBootstrap1B);
        Consequence bootstrapConsequence = new Consequence(){

            public void invoke(Tuple tuple) throws ConsequenceException {
                WorkingMemory workingMemory = tuple.getWorkingMemory();
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration);
                f.setValue(1L);
                System.err.println(f.getSequence() + " == " + f.getValue());
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(f), f);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        bootstrap1Rule.setConsequence(bootstrapConsequence);
        ruleSet.addRule(bootstrap1Rule);
        Rule bootstrap2Rule = new Rule("Bootstrap 2");
        final Declaration fDeclaration2 = bootstrap2Rule.addParameterDeclaration("f", fibonacciType);
        Condition conditionBootstrap2A = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration2);
                return f.getSequence() == 2;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{fDeclaration2};
            }

            public String toString() {
                return "f.getSequence() == 2";
            }
        };
        bootstrap2Rule.addCondition(conditionBootstrap2A);
        Condition conditionBootstrap2B = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration2);
                return f.getValue() == -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{fDeclaration2};
            }

            public String toString() {
                return "f.getValue() == -1";
            }
        };
        bootstrap2Rule.addCondition(conditionBootstrap2B);
        Consequence bootstrapConsequence2 = new Consequence(){

            public void invoke(Tuple tuple) throws ConsequenceException {
                WorkingMemory workingMemory = tuple.getWorkingMemory();
                Fibonacci f = (Fibonacci)tuple.get(fDeclaration2);
                f.setValue(1L);
                System.err.println(f.getSequence() + " == " + f.getValue());
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(f), f);
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        bootstrap2Rule.setConsequence(bootstrapConsequence2);
        ruleSet.addRule(bootstrap2Rule);
        Rule recurseRule = new Rule("Recurse");
        recurseRule.setSalience(10);
        final Declaration fDeclarationRecurse = recurseRule.addParameterDeclaration("f", fibonacciType);
        Condition conditionRecurse = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f = (Fibonacci)tuple.get(fDeclarationRecurse);
                return f.getValue() == -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{fDeclarationRecurse};
            }

            public String toString() {
                return "f.getValue() == -1";
            }
        };
        recurseRule.addCondition(conditionRecurse);
        Consequence recurseConsequence = new Consequence(){

            public void invoke(Tuple tuple) throws ConsequenceException {
                WorkingMemory workingMemory = tuple.getWorkingMemory();
                Fibonacci f = (Fibonacci)tuple.get(fDeclarationRecurse);
                System.err.println("recurse for " + f.getSequence());
                try {
                    workingMemory.assertObject(new Fibonacci(f.getSequence() - 1));
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        recurseRule.setConsequence(recurseConsequence);
        ruleSet.addRule(recurseRule);
        Rule calculateRule = new Rule("Calculate");
        final Declaration f1Declaration = calculateRule.addParameterDeclaration("f1", fibonacciType);
        final Declaration f2Declaration = calculateRule.addParameterDeclaration("f2", fibonacciType);
        final Declaration f3Declaration = calculateRule.addParameterDeclaration("f3", fibonacciType);
        Condition conditionCalculateA = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f1 = (Fibonacci)tuple.get(f1Declaration);
                Fibonacci f2 = (Fibonacci)tuple.get(f2Declaration);
                return f2.getSequence() == f1.getSequence() + 1;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{f1Declaration, f2Declaration};
            }

            public String toString() {
                return "f2.getSequence() == (f1.getSequence()+1)";
            }
        };
        calculateRule.addCondition(conditionCalculateA);
        Condition conditionCalculateB = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f2 = (Fibonacci)tuple.get(f2Declaration);
                Fibonacci f3 = (Fibonacci)tuple.get(f3Declaration);
                return f3.getSequence() == f2.getSequence() + 1;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{f2Declaration, f3Declaration};
            }

            public String toString() {
                return "f3.getSequence() == (f2.getSequence()+1)";
            }
        };
        calculateRule.addCondition(conditionCalculateB);
        Condition conditionCalculateC = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f1 = (Fibonacci)tuple.get(f1Declaration);
                return f1.getValue() != -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{f1Declaration};
            }

            public String toString() {
                return "f1.getValue() != -1";
            }
        };
        calculateRule.addCondition(conditionCalculateC);
        Condition conditionCalculateD = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f2 = (Fibonacci)tuple.get(f2Declaration);
                return f2.getValue() != -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{f2Declaration};
            }

            public String toString() {
                return "f2.getValue() != -1";
            }
        };
        calculateRule.addCondition(conditionCalculateD);
        Condition conditionCalculateE = new Condition(){

            public boolean isAllowed(Tuple tuple) {
                Fibonacci f3 = (Fibonacci)tuple.get(f3Declaration);
                return f3.getValue() == -1L;
            }

            public Declaration[] getRequiredTupleMembers() {
                return new Declaration[]{f3Declaration};
            }

            public String toString() {
                return "f3.getValue() == -1";
            }
        };
        calculateRule.addCondition(conditionCalculateE);
        Consequence calculateConsequence = new Consequence(){

            public void invoke(Tuple tuple) throws ConsequenceException {
                WorkingMemory workingMemory = tuple.getWorkingMemory();
                Fibonacci f1 = (Fibonacci)tuple.get(f1Declaration);
                Fibonacci f2 = (Fibonacci)tuple.get(f2Declaration);
                Fibonacci f3 = (Fibonacci)tuple.get(f3Declaration);
                f3.setValue(f1.getValue() + f2.getValue());
                System.err.println(f3.getSequence() + " == " + f3.getValue());
                try {
                    workingMemory.modifyObject(tuple.getFactHandleForObject(f3), f3);
                    workingMemory.retractObject(tuple.getFactHandleForObject(f1));
                }
                catch (FactException e) {
                    throw new ConsequenceException(e);
                }
            }
        };
        calculateRule.setConsequence(calculateConsequence);
        ruleSet.addRule(calculateRule);
        RuleBaseBuilder builder = new RuleBaseBuilder();
        builder.addRuleSet(ruleSet);
        RuleBase ruleBase = builder.build();
        WorkingMemory workingMemory = ruleBase.newWorkingMemory();
        System.out.println("DUMP RETE");
        System.out.println("---------");
        Dumper dumper = new Dumper(ruleBase);
        dumper.dumpRete(System.err);
        System.out.println("DUMP RETE DOT");
        System.out.println("---------");
        dumper.dumpReteToDot(System.err);
        Fibonacci fibonacci = new Fibonacci(50);
        long start = System.currentTimeMillis();
        workingMemory.assertObject(fibonacci);
        workingMemory.fireAllRules();
        long stop = System.currentTimeMillis();
        System.err.println("fibonacci(" + fibonacci.getSequence() + ") == " + fibonacci.getValue() + " took " + (stop - start) + "ms");
    }
}

