/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.benchmarks.waltz;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.DroolsException;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.conflict.ComplexityConflictResolver;
import org.drools.conflict.CompositeConflictResolver;
import org.drools.conflict.LoadOrderConflictResolver;
import org.drools.examples.benchmarks.waltz.WaltzWMEL;
import org.drools.examples.benchmarks.waltz.model.Line;
import org.drools.examples.benchmarks.waltz.model.Stage;
import org.drools.io.RuleBaseLoader;
import org.drools.reteoo.Dumper;
import org.drools.spi.ConflictResolver;
import org.xml.sax.SAXException;

public class WaltzBenchmark {
    private static final String DRL_FILE = "waltz.drl";
    private static final String DOT_FILE = "waltz.dot";
    private List inputObjects;
    private WorkingMemory workingMemory;

    public static void main(String[] args) throws DroolsException, IOException, SAXException {
        String datFile = "waltz0.dat";
        if (args.length > 0) {
            datFile = args[0];
        }
        WaltzBenchmark benchmark = new WaltzBenchmark(datFile);
        long start = System.currentTimeMillis();
        benchmark.run();
        System.out.println("Elapsed time: " + (System.currentTimeMillis() - start) + " ms");
    }

    public WaltzBenchmark(String datFile) throws DroolsException, IOException, SAXException {
        System.out.println("Loading DRL: waltz.drl...");
        RuleBase ruleBase = RuleBaseLoader.loadFromUrl(WaltzBenchmark.class.getResource(DRL_FILE), (ConflictResolver)new CompositeConflictResolver(new ConflictResolver[]{ComplexityConflictResolver.getInstance(), LoadOrderConflictResolver.getInstance()}));
        File dotFile = new File(DOT_FILE);
        System.out.println("Creating DOT: " + dotFile.getCanonicalPath() + "...");
        new Dumper(ruleBase).dumpReteToDot(new PrintStream(new FileOutputStream(dotFile)));
        this.workingMemory = ruleBase.newWorkingMemory();
        this.workingMemory.addEventListener(new WaltzWMEL());
        System.out.println("Reading DAT: " + datFile + "...");
        this.inputObjects = WaltzBenchmark.getInputObjects(this.getClass().getResourceAsStream(datFile));
    }

    public void run() throws FactException {
        System.out.println("Asserting initial objects...");
        Iterator i = this.inputObjects.iterator();
        while (i.hasNext()) {
            this.workingMemory.assertObject(i.next());
        }
        System.out.println("Firing all rules...");
        this.workingMemory.fireAllRules();
    }

    private static List getInputObjects(InputStream inputStream) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String make = st.nextToken();
            if (!"make".equals(make)) {
                throw new IOException("expected 'make' in: " + line);
            }
            String type = st.nextToken();
            if ("line".equals(type)) {
                if (!"^p1".equals(st.nextToken())) {
                    throw new IOException("expected '^p1' in: " + line);
                }
                int p1 = Integer.parseInt(st.nextToken());
                if (!"^p2".equals(st.nextToken())) {
                    throw new IOException("expected '^p2' in: " + line);
                }
                int p2 = Integer.parseInt(st.nextToken());
                list.add(new Line(p1, p2));
            }
            if (!"stage".equals(type)) continue;
            if (!"^value".equals(st.nextToken())) {
                throw new IOException("expected '^value' in: " + line);
            }
            list.add(new Stage(st.nextToken()));
        }
        inputStream.close();
        return list;
    }
}

