/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.parser;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Parameter;
import org.drools.decisiontable.model.Variable;

public class RuleSheetParserUtil {
    private RuleSheetParserUtil() {
    }

    public static String getRuleName(String ruleRow) {
        int left = ruleRow.indexOf("RuleTable");
        int right = ruleRow.indexOf(40);
        if (left == -1 || right == -1) {
            RuleSheetParserUtil.invalidRuleTableDef(ruleRow);
        }
        return ruleRow.substring(left + "RuleTable".length(), right).trim();
    }

    private static void invalidRuleTableDef(String ruleRow) {
        throw new IllegalArgumentException("Invalid rule table header cell, must have some parameters. Should be in the format of 'RuleTable some name (Type paramName, Type, paramName2)'. It was: \n [" + ruleRow + "] \n");
    }

    public static List getParameterList(String ruleRow) {
        ArrayList<Parameter> paramList = new ArrayList<Parameter>();
        int left = ruleRow.indexOf(40);
        int right = ruleRow.indexOf(41);
        if (left == -1 || right == -1) {
            RuleSheetParserUtil.invalidRuleTableDef(ruleRow);
        }
        String params = ruleRow.substring(left + 1, right);
        StringTokenizer tokens = new StringTokenizer(params, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Parameter param = new Parameter();
            StringTokenizer paramTokens = new StringTokenizer(token, " ");
            param.setClassName(paramTokens.nextToken());
            param.setIdentifier(paramTokens.nextToken());
            paramList.add(param);
        }
        if (paramList.size() == 0) {
            throw new IllegalArgumentException("No parameters found in RuleTable definition cell.");
        }
        return paramList;
    }

    public static List getImportList(String importCell) {
        LinkedList<Import> importList = new LinkedList<Import>();
        if (importCell == null) {
            return importList;
        }
        StringTokenizer tokens = new StringTokenizer(importCell, ",");
        while (tokens.hasMoreTokens()) {
            Import imp = new Import();
            imp.setClassName(tokens.nextToken().trim());
            importList.add(imp);
        }
        return importList;
    }

    public static List getVariableList(String importCell) {
        LinkedList<Variable> variableList = new LinkedList<Variable>();
        if (importCell == null) {
            return variableList;
        }
        StringTokenizer tokens = new StringTokenizer(importCell, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Variable vars = new Variable();
            StringTokenizer paramTokens = new StringTokenizer(token, " ");
            vars.setClassName(paramTokens.nextToken());
            vars.setIdentifier(paramTokens.nextToken());
            variableList.add(vars);
        }
        return variableList;
    }

    public static boolean isStringMeaningTrue(String property) {
        if (property == null) {
            return false;
        }
        if ((property = property.trim()).equalsIgnoreCase("true")) {
            return true;
        }
        if (property.startsWith("Y")) {
            return true;
        }
        if (property.startsWith("y")) {
            return true;
        }
        return property.equalsIgnoreCase("on");
    }
}

