/*
 * Decompiled with CFR 0.152.
 */
package org.drools.decisiontable.model;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.drools.decisiontable.model.DRLJavaEmitter;
import org.drools.decisiontable.model.Functions;
import org.drools.decisiontable.model.Import;
import org.drools.decisiontable.model.Rule;
import org.drools.decisiontable.model.Variable;

public class Ruleset
implements DRLJavaEmitter {
    private String _name;
    private List _imports;
    private List _variables;
    private List _rules;
    private Functions _functions;

    public Ruleset(String name) {
        this._name = name;
        this._imports = new LinkedList();
        this._variables = new LinkedList();
        this._rules = new LinkedList();
        this._functions = new Functions();
    }

    public void addImport(Import imp) {
        this._imports.add(imp);
    }

    public void addVariable(Variable varz) {
        this._variables.add(varz);
    }

    public void addRule(Rule rule) {
        this._rules.add(rule);
    }

    public void addFunctions(String listing) {
        this._functions.setFunctionsListing(listing);
    }

    public String toXML() {
        String xml = "<?xml version=\"1.0\"?> <rule-set name=\"" + this._name + "\" " + "xmlns=\"http://drools.org/rules\" " + "xmlns:java=\"http://drools.org/semantics/java\" " + "xmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\" " + "xs:schemaLocation=\"http://drools.org/rules rules.xsd http://drools.org/semantics/java java.xsd\">";
        xml = xml + "\n";
        xml = xml + this.generateXml(this._imports) + "\n";
        xml = xml + this.generateXml(this._variables);
        xml = xml + "\n" + this._functions.toXML() + "\n\n";
        xml = xml + this.generateXml(this._rules);
        xml = xml + "\n\n\n</rule-set>";
        return xml.trim();
    }

    private String generateXml(List list) {
        StringBuffer buf = new StringBuffer();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DRLJavaEmitter emitter = (DRLJavaEmitter)it.next();
            buf.append(emitter.toXML());
        }
        return buf.toString();
    }

    public String getName() {
        return this._name;
    }

    public List getImports() {
        return this._imports;
    }

    public List getVariables() {
        return this._variables;
    }

    public List getRules() {
        return this._rules;
    }
}

