/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.etl.pentaho;

import java.util.Objects;
import org.openvpms.etl.pentaho.Messages;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class ApplicationContextMgr {
    private static DatabaseMeta db;
    private static ConfigurableApplicationContext context;
    private static final String APPLICATION_CONTEXT = "applicationContext.xml";

    private ApplicationContextMgr() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ApplicationContext getContext(DatabaseMeta database, LogChannelInterface log) throws KettleException {
        if (context == null || !Objects.equals(db, database)) {
            if (context != null) {
                context.close();
            }
            log.logBasic(Messages.get("ApplicationContextMgr.BeginInit", database.getURL()));
            Thread thread = Thread.currentThread();
            ClassLoader loader = thread.getContextClassLoader();
            Class<ApplicationContextMgr> clazz = ApplicationContextMgr.class;
            thread.setContextClassLoader(clazz.getClassLoader());
            try {
                context = ApplicationContextMgr.load(database);
                log.logBasic(Messages.get("ApplicationContextMgr.EndInit", new Object[0]));
            }
            finally {
                thread.setContextClassLoader(loader);
            }
            db = database;
        }
        return context;
    }

    private static ConfigurableApplicationContext load(DatabaseMeta database) throws KettleException {
        String driver = database.getDriverClass();
        String url = database.getURL();
        String user = database.getUsername();
        String password = database.getPassword();
        ClassPathXmlApplicationContext context = new ClassPathXmlApplicationContext(new String[]{APPLICATION_CONTEXT}, false);
        context.addBeanFactoryPostProcessor(beanFactory -> {
            BeanDefinition def = beanFactory.getBeanDefinition("dataSource");
            MutablePropertyValues properties = def.getPropertyValues();
            properties.addPropertyValue("driverClassName", (Object)driver);
            properties.addPropertyValue("url", (Object)url);
            properties.addPropertyValue("username", (Object)user);
            properties.addPropertyValue("password", (Object)password);
        });
        context.refresh();
        return context;
    }
}

