/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.internal.i18n;


import org.openvpms.component.i18n.Message;
import org.openvpms.component.i18n.Messages;
import org.openvpms.paymentprocessor.transaction.Transaction;

/**
 * Messages reported by the payment processor API.
 *
 * @author Tim Anderson
 */
public class PaymentProcessorMessages {

    /**
     * The messages.
     */
    private static final Messages messages = new Messages("PAYMENT", PaymentProcessorMessages.class);

    /**
     * Default constructor.
     */
    private PaymentProcessorMessages() {
        // no-op
    }

    /**
     * Message to indicate that the payment processor for a configuration is unavailable.
     *
     * @param name the configuration name
     * @return a new message
     */
    public static Message serviceUnavailable(String name) {
        return messages.create(1, name);
    }

    /**
     * Message to indicate that a transaction status cannot be updated.
     *
     * @param current the current status
     * @param other   the requested status
     * @return a new message
     */
    public static Message cannotChangeStatus(Transaction.Status current, Transaction.Status other) {
        return messages.create(100, current, other);
    }

    /**
     * Message to indicate that the transaction identifier archetype cannot be changed.
     *
     * @param current the current archetype
     * @param other   the requested archetype
     * @return a new message
     */
    public static Message differentTxnIdentifierArchetype(String current, String other) {
        return messages.create(101, current, other);
    }
}
