/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.transaction;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Date;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.math.Currency;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.practice.Location;
import org.openvpms.paymentprocessor.internal.transaction.TransactionUpdaterImpl;
import org.openvpms.paymentprocessor.processor.PaymentProcessor;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.paymentprocessor.transaction.TransactionUpdater;
import org.openvpms.plugin.internal.service.security.RunAsService;
import org.springframework.transaction.PlatformTransactionManager;

public class TransactionImpl
implements Transaction {
    private final FinancialAct act;
    private final IMObjectBean bean;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final PracticeService practiceService;
    private final CustomerAccountRules rules;
    private final PlatformTransactionManager transactionManager;
    private final RunAsService runAs;
    private Customer customer;
    private boolean completionTriggersPost = false;
    static final String TRANSACTION_ID = "transactionId";

    public TransactionImpl(FinancialAct act, ArchetypeService service, DomainService domainService, PracticeService practiceService, CustomerAccountRules rules, PlatformTransactionManager transactionManager, RunAsService runAs) {
        this.act = act;
        this.service = service;
        this.bean = service.getBean((IMObject)act);
        this.domainService = domainService;
        this.practiceService = practiceService;
        this.rules = rules;
        this.transactionManager = transactionManager;
        this.runAs = runAs;
    }

    public TransactionImpl(IMObjectBean bean, ArchetypeService service, DomainService domainService, PracticeService practiceService, CustomerAccountRules rules, PlatformTransactionManager transactionManager, RunAsService runAs) {
        this.act = (FinancialAct)bean.getObject(FinancialAct.class);
        this.service = service;
        this.bean = bean;
        this.domainService = domainService;
        this.practiceService = practiceService;
        this.rules = rules;
        this.transactionManager = transactionManager;
        this.runAs = runAs;
    }

    public long getId() {
        return this.act.getId();
    }

    public TransactionMode getTransactionMode() {
        return TransactionMode.valueOf((String)this.getBean().getString("transactionMode"));
    }

    public Reference getParent() {
        ActIdentity identity = (ActIdentity)this.bean.getObject("parentId", ActIdentity.class);
        long id = identity != null ? Long.parseLong(identity.getIdentity()) : -1L;
        String archetype = this.act.isA("act.paymentProcessorPayment") ? "act.customerAccountPayment" : "act.customerAccountRefund";
        return new IMObjectReference(archetype, id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TransactionImpl) {
            return this.act.equals(((TransactionImpl)obj).act);
        }
        return false;
    }

    public int hashCode() {
        return this.act.hashCode();
    }

    public String getTransactionId() {
        ActIdentity identity = this.getTransactionIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public ActIdentity getTransactionIdentity() {
        return (ActIdentity)this.bean.getObject(TRANSACTION_ID, ActIdentity.class);
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityStartTime());
    }

    public Transaction.Status getStatus() {
        return Transaction.Status.valueOf((String)this.act.getStatus());
    }

    public String getMessage() {
        return this.bean.getString("message");
    }

    public void setStatus(Transaction.Status status) {
        this.state().status(status).update();
    }

    public void setStatus(Transaction.Status status, String message) {
        this.state().status(status).message(message).update();
    }

    public Customer getCustomer() {
        if (this.customer == null) {
            Party party = (Party)this.bean.getTarget("customer", Party.class);
            if (party == null) {
                throw new IllegalStateException("Transaction has no customer");
            }
            this.customer = (Customer)this.domainService.create((IMObject)party, Customer.class);
        }
        return this.customer;
    }

    public String getCustomerId(String archetype) {
        EntityIdentity identity = this.getCustomerIdentity(archetype);
        return identity != null ? identity.getIdentity() : null;
    }

    public EntityIdentity getCustomerIdentity(String archetype) {
        if (!TypeHelper.isA((String)archetype, (String[])new String[]{"entityIdentity.paymentProcessor*"})) {
            throw new IllegalArgumentException("Invalid identity archetype: " + archetype);
        }
        return this.getCustomer().getIdentity(archetype);
    }

    public PaymentProcessor getPaymentProcessor() {
        Entity entity = (Entity)this.bean.getTarget("paymentProcessor", Entity.class);
        if (entity == null) {
            throw new IllegalStateException("Transaction has no payment processor");
        }
        return (PaymentProcessor)this.domainService.create((IMObject)entity, PaymentProcessor.class);
    }

    public Location getLocation() {
        Party location = (Party)this.bean.getTarget("location", Party.class);
        if (location == null) {
            throw new IllegalStateException("Transaction has no location");
        }
        return (Location)this.domainService.create((IMObject)location, Location.class);
    }

    public BigDecimal getAmount() {
        return this.bean.getBigDecimal("amount", BigDecimal.ZERO);
    }

    public String getCurrencyCode() {
        Currency currency = this.practiceService.getCurrency();
        if (currency == null) {
            throw new IllegalStateException("No practice currency");
        }
        return currency.getCode();
    }

    public java.util.Currency getCurrency() {
        String code = this.getCurrencyCode();
        java.util.Currency result = java.util.Currency.getInstance(code);
        if (result == null) {
            throw new IllegalStateException("Failed to determine currency for currency code=" + code);
        }
        return result;
    }

    public String getEmail() {
        return this.getBean().getString("email");
    }

    public boolean getNotified() {
        return this.getBean().getBoolean("notified");
    }

    public String getUrl() {
        return this.getBean().getString("url");
    }

    public TransactionUpdater state() {
        return new TransactionUpdaterImpl(this.bean, this.completionTriggersPost, this.service, this.transactionManager, this.rules, this.runAs);
    }

    public boolean completionTriggersPost() {
        return this.completionTriggersPost;
    }

    public void setCompletionTriggersPost(boolean completionTriggersPost) {
        this.completionTriggersPost = completionTriggersPost;
    }

    protected IMObjectBean getBean() {
        return this.bean;
    }

    protected DomainService getDomainService() {
        return this.domainService;
    }
}

