/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.transaction;

import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.query.DomainQueryImpl;
import org.openvpms.domain.query.Filter;
import org.openvpms.paymentprocessor.internal.transaction.PaymentProcessorTransactionFactory;
import org.openvpms.paymentprocessor.processor.PaymentProcessor;
import org.openvpms.paymentprocessor.transaction.AbstractTransactionQuery;
import org.openvpms.paymentprocessor.transaction.Transaction;

public class AbstractTransactionQueryImpl<T extends Transaction, Q extends AbstractTransactionQuery<T, Q>>
extends DomainQueryImpl<T, FinancialAct, Q>
implements AbstractTransactionQuery<T, Q> {
    private final PaymentProcessorTransactionFactory factory;
    private String idArchetype;
    private String id;
    private PaymentProcessor processor;
    private Transaction.Status status;

    protected AbstractTransactionQueryImpl(Class<T> domainTpe, PaymentProcessorTransactionFactory factory, ArchetypeService service, DomainService domainService) {
        super(domainTpe, FinancialAct.class, service, domainService);
        this.factory = factory;
    }

    public Q transactionId(String archetype) {
        return this.transactionId(archetype, null);
    }

    public Q transactionId(String archetype, String id) {
        if (!TypeHelper.matches((String)archetype, (String)"actIdentity.paymentProcessorTransaction*")) {
            throw new IllegalArgumentException("Invalid transaction id archetype: " + archetype);
        }
        this.idArchetype = archetype;
        this.id = id;
        return (Q)((AbstractTransactionQuery)this.getThis());
    }

    public Q paymentProcessor(PaymentProcessor processor) {
        this.processor = processor;
        return (Q)((AbstractTransactionQuery)this.getThis());
    }

    public Q status(Transaction.Status status) {
        this.status = status;
        return (Q)((AbstractTransactionQuery)this.getThis());
    }

    protected void addPredicates(List<Predicate> predicates, CriteriaQuery<FinancialAct> query, Root<FinancialAct> from, CriteriaBuilder builder) {
        super.addPredicates(predicates, query, from, builder);
        if (this.idArchetype != null) {
            Join transactionIds = from.join("transactionId", this.idArchetype);
            transactionIds.alias("transactionIds");
            if (this.id != null) {
                predicates.add(this.createPredicate(transactionIds.get("identity"), Filter.equal((Object)this.id), builder));
            }
        }
        if (this.processor != null) {
            Join processors = from.join("paymentProcessor");
            processors.alias("processors").on((Expression)builder.equal((Expression)processors.get("entity"), (Object)this.processor.getObjectReference()));
        }
        if (this.status != null) {
            predicates.add(this.createPredicate(from.get("status"), Filter.equal((Object)this.status.toString()), builder));
        }
    }

    protected T createDomainObject(FinancialAct object) {
        return (T)this.factory.getTransaction(object, true);
    }
}

