/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.internal.transaction;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.archetype.rules.practice.PracticeService;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.paymentprocessor.transaction.Payment;
import org.openvpms.plugin.internal.service.security.RunAsService;
import org.springframework.transaction.PlatformTransactionManager;

/**
 * Default implementation of {@link Payment}.
 *
 * @author Tim Anderson
 */
public class PaymentImpl extends TransactionImpl implements Payment {

    /**
     * Constructs a {@link PaymentImpl}.
     *
     * @param act                the act
     * @param service            the archetype service
     * @param domainService      the domain service
     * @param practiceService    the practice service
     * @param rules              the customer account rules
     * @param transactionManager the transaction manager
     * @param runAs              the run-as service
     */
    public PaymentImpl(FinancialAct act, ArchetypeService service, DomainService domainService,
                       PracticeService practiceService, CustomerAccountRules rules,
                       PlatformTransactionManager transactionManager, RunAsService runAs) {
        super(act, service, domainService, practiceService, rules, transactionManager, runAs);
    }

    /**
     * Constructs a {@link PaymentImpl}.
     *
     * @param bean               a bean wrapping the act
     * @param service            the archetype service
     * @param domainService      the domain object service
     * @param practiceService    the practice service
     * @param rules              the customer account rules
     * @param transactionManager the transaction manager
     * @param runAs              the run-as service
     */
    public PaymentImpl(IMObjectBean bean, ArchetypeService service, DomainService domainService,
                       PracticeService practiceService, CustomerAccountRules rules,
                       PlatformTransactionManager transactionManager, RunAsService runAs) {
        super(bean, service, domainService, practiceService, rules, transactionManager, runAs);
    }
}