/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.transaction;

import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.paymentprocessor.internal.transaction.PaymentProcessorTransactionFactory;
import org.openvpms.paymentprocessor.internal.transaction.PaymentQueryImpl;
import org.openvpms.paymentprocessor.internal.transaction.RefundQueryImpl;
import org.openvpms.paymentprocessor.internal.transaction.TransactionQueryImpl;
import org.openvpms.paymentprocessor.transaction.Payment;
import org.openvpms.paymentprocessor.transaction.PaymentQuery;
import org.openvpms.paymentprocessor.transaction.Refund;
import org.openvpms.paymentprocessor.transaction.RefundQuery;
import org.openvpms.paymentprocessor.transaction.TransactionQuery;
import org.openvpms.paymentprocessor.transaction.Transactions;

public class TransactionsImpl
implements Transactions {
    private final ArchetypeService service;
    private final PaymentProcessorTransactionFactory factory;
    private final DomainService domainService;

    public TransactionsImpl(ArchetypeService service, PaymentProcessorTransactionFactory factory, DomainService domainService) {
        this.service = service;
        this.factory = factory;
        this.domainService = domainService;
    }

    public Payment getPayment(long id) {
        return (Payment)((PaymentQuery)this.getPaymentQuery().id(id)).findFirst();
    }

    public Refund getRefund(long id) {
        return (Refund)((RefundQuery)this.getRefundQuery().id(id)).findFirst();
    }

    public Payment getPayment(String archetype, String id) {
        return (Payment)((PaymentQuery)this.getPaymentQuery().transactionId(archetype, id)).findFirst();
    }

    public Refund getRefund(String archetype, String id) {
        return (Refund)((RefundQuery)this.getRefundQuery().transactionId(archetype, id)).findFirst();
    }

    public TransactionQuery getQuery() {
        return new TransactionQueryImpl(this.factory, this.service, this.domainService);
    }

    public PaymentQuery getPaymentQuery() {
        return new PaymentQueryImpl(this.factory, this.service, this.domainService);
    }

    public RefundQuery getRefundQuery() {
        return new RefundQueryImpl(this.factory, this.service, this.domainService);
    }
}

