/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.service;

import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.paymentprocessor.service.PaymentRequirements;
import org.openvpms.paymentprocessor.service.RefundRequirements;
import org.openvpms.paymentprocessor.service.ValidationStatus;
import org.openvpms.paymentprocessor.transaction.Payment;
import org.openvpms.paymentprocessor.transaction.Refund;
import org.openvpms.paymentprocessor.transaction.Transaction;

public class PaymentProcessorServiceAdapter {
    private final PaymentProcessorService service;

    public PaymentProcessorServiceAdapter(PaymentProcessorService service) {
        this.service = service;
    }

    public PaymentRequirements getPaymentRequirements(TransactionMode mode) {
        return (PaymentRequirements)this.service.getPaymentCapabilities().getRequirements(mode);
    }

    public RefundRequirements getRefundRequirements(TransactionMode mode) {
        return (RefundRequirements)this.service.getRefundCapabilities().getRequirements(mode);
    }

    public ValidationStatus prepare(Transaction transaction) {
        ValidationStatus result = transaction instanceof Payment ? this.service.prepare((Payment)transaction) : this.service.prepare((Refund)transaction);
        return result;
    }

    public void submit(Transaction transaction, boolean isNew) {
        if (transaction instanceof Payment) {
            Payment payment = (Payment)transaction;
            this.service.submit(payment, isNew);
        } else {
            Refund refund = (Refund)transaction;
            this.service.submit(refund, isNew);
        }
    }

    public boolean check(Transaction transaction) {
        boolean result = transaction instanceof Payment ? this.service.check((Payment)transaction) : this.service.check((Refund)transaction);
        return result;
    }

    public void cancel(Transaction transaction) {
        if (transaction instanceof Payment) {
            this.service.cancel((Payment)transaction);
        } else {
            this.service.cancel((Refund)transaction);
        }
    }
}

