/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.transaction;

import java.util.Objects;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Identity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.paymentprocessor.internal.i18n.PaymentProcessorMessages;
import org.openvpms.paymentprocessor.transaction.Transaction;
import org.openvpms.paymentprocessor.transaction.TransactionUpdater;
import org.openvpms.plugin.internal.service.security.RunAsService;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class TransactionUpdaterImpl
implements TransactionUpdater {
    private final IMObjectBean bean;
    private final boolean completionTriggersPost;
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final CustomerAccountRules rules;
    private final RunAsService runAs;
    private Transaction.Status status;
    private MutableObject<String> message;
    private String transactionIdArchetype;
    private String transactionId;
    private MutableObject<String> url;

    public TransactionUpdaterImpl(IMObjectBean bean, boolean completionTriggersPost, ArchetypeService service, PlatformTransactionManager transactionManager, CustomerAccountRules rules, RunAsService runAs) {
        this.bean = bean;
        this.completionTriggersPost = completionTriggersPost;
        this.service = service;
        this.transactionManager = transactionManager;
        this.rules = rules;
        this.runAs = runAs;
    }

    public TransactionUpdater status(Transaction.Status status) {
        this.status = status;
        return this;
    }

    public TransactionUpdater message(String message) {
        this.message = new MutableObject((Object)message);
        return this;
    }

    public TransactionUpdater transactionId(String archetype, String id) {
        this.transactionIdArchetype = archetype;
        this.transactionId = id;
        return this;
    }

    public TransactionUpdater url(String url) {
        this.url = new MutableObject((Object)url);
        return this;
    }

    public boolean update() {
        boolean completed;
        Transaction.Status current = this.getStatus();
        boolean updated = false;
        if (this.status != null && this.status != current) {
            if (this.isTerminalStatus(current) || current == Transaction.Status.SUBMITTED && !this.isTerminalStatus(this.status)) {
                throw new PaymentProcessorException(PaymentProcessorMessages.cannotChangeStatus(current, this.status));
            }
            this.bean.setValue("status", (Object)this.status.toString());
            updated = true;
            completed = this.status == Transaction.Status.COMPLETED;
        } else {
            completed = current == Transaction.Status.COMPLETED;
        }
        updated |= this.updateIfChanged("message", (Mutable<?>)this.message);
        updated |= this.updateTransactionId();
        this.reset();
        if (updated |= this.updateIfChanged("url", (Mutable<?>)this.url)) {
            this.bean.save();
        }
        if (completed && this.completionTriggersPost) {
            this.post();
        }
        return updated;
    }

    private void post() {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus status) {
                FinancialAct parent;
                FinancialAct item = (FinancialAct)TransactionUpdaterImpl.this.bean.getSource("transaction", FinancialAct.class);
                if (item != null && (parent = (FinancialAct)TransactionUpdaterImpl.this.service.getBean((IMObject)item).getSource("transaction", FinancialAct.class)) != null && TransactionUpdaterImpl.this.rules.canPost(parent)) {
                    TransactionUpdaterImpl.this.runAs.run(() -> TransactionUpdaterImpl.this.rules.post(parent));
                }
            }
        });
    }

    private boolean isTerminalStatus(Transaction.Status status) {
        return status == Transaction.Status.COMPLETED || status == Transaction.Status.CANCELLED || status == Transaction.Status.ERROR;
    }

    private boolean updateTransactionId() {
        boolean updated = false;
        if (this.transactionId != null) {
            Identity identity = this.getIdentity(this.bean, this.transactionIdArchetype, "transactionId");
            if (!identity.isNew()) {
                if (!identity.isA(this.transactionIdArchetype)) {
                    throw new PaymentProcessorException(PaymentProcessorMessages.differentTxnIdentifierArchetype(identity.getArchetype(), this.transactionIdArchetype));
                }
            } else {
                updated = true;
            }
            updated |= this.updateIdentity(identity, this.transactionId);
        }
        return updated;
    }

    private boolean updateIdentity(Identity identity, String value) {
        boolean updated = false;
        if (!Objects.equals(identity.getIdentity(), value)) {
            identity.setIdentity(value);
            updated = true;
        }
        return updated;
    }

    private Identity getIdentity(IMObjectBean bean, String archetype, String node) {
        Identity identity = (Identity)bean.getObject(node, Identity.class);
        if (identity == null) {
            identity = (Identity)this.service.create(archetype, Identity.class);
            bean.addValue(node, (IMObject)identity);
        }
        return identity;
    }

    private Transaction.Status getStatus() {
        Act act = (Act)this.bean.getObject();
        String result = act.getStatus();
        return result != null ? Transaction.Status.valueOf((String)result) : null;
    }

    private void reset() {
        this.status = null;
        this.transactionId = null;
        this.transactionIdArchetype = null;
        this.url = null;
    }

    private boolean updateIfChanged(String name, Object value) {
        boolean updated = false;
        if (!Objects.equals(value, this.bean.getValue(name))) {
            this.bean.setValue(name, value);
            updated = true;
        }
        return updated;
    }

    private boolean updateIfChanged(String name, Mutable<?> value) {
        return value != null && this.updateIfChanged(name, value.getValue());
    }
}

