/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.transaction;

import java.math.BigDecimal;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.paymentprocessor.internal.transaction.PaymentImpl;
import org.openvpms.paymentprocessor.internal.transaction.RefundImpl;
import org.openvpms.paymentprocessor.internal.transaction.TransactionImpl;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.transaction.Transaction;

public class PaymentProcessorTransactionFactory {
    private final ArchetypeService service;
    private final DomainService domainService;

    public PaymentProcessorTransactionFactory(ArchetypeService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public FinancialAct createPayment(FinancialAct parentPayment, BigDecimal amount, Entity paymentProcessor, TransactionMode mode, String email, String description) {
        return this.createTransaction(parentPayment, "act.customerAccountPayment", "act.paymentProcessorPayment", amount, paymentProcessor, mode, email, description);
    }

    public FinancialAct createRefund(FinancialAct parentRefund, BigDecimal amount, Entity paymentProcessor, TransactionMode mode, String email, String description) {
        return this.createTransaction(parentRefund, "act.customerAccountRefund", "act.paymentProcessorRefund", amount, paymentProcessor, mode, email, description);
    }

    public Transaction getTransaction(FinancialAct act) {
        return this.getTransaction(act, false);
    }

    public Transaction getTransaction(FinancialAct act, boolean completionTriggersPost) {
        TransactionImpl transaction;
        if (act.isA("act.paymentProcessorPayment")) {
            transaction = (TransactionImpl)this.domainService.create((IMObject)act, PaymentImpl.class);
        } else if (act.isA("act.paymentProcessorRefund")) {
            transaction = (TransactionImpl)this.domainService.create((IMObject)act, RefundImpl.class);
        } else {
            throw new IllegalArgumentException("Invalid transaction type: " + act.getArchetype() + " for argument 'act'");
        }
        transaction.setCompletionTriggersPost(completionTriggersPost);
        return transaction;
    }

    private FinancialAct createTransaction(FinancialAct parent, String parentArchetype, String archetype, BigDecimal amount, Entity paymentProcessor, TransactionMode mode, String email, String description) {
        if (parent.isNew()) {
            throw new IllegalStateException("Parent act must be saved");
        }
        if (!parent.isA(parentArchetype)) {
            throw new IllegalArgumentException("Expected parent of type " + parentArchetype + " but got " + parent.getArchetype());
        }
        IMObjectBean parentBean = this.service.getBean((IMObject)parent);
        Reference customer = parentBean.getTargetRef("customer");
        if (customer == null) {
            throw new IllegalStateException("Parent act has no customer");
        }
        Reference location = parentBean.getTargetRef("location");
        if (location == null) {
            throw new IllegalStateException("Parent act has no location");
        }
        FinancialAct act = (FinancialAct)this.service.create(archetype, FinancialAct.class);
        ActIdentity identity = (ActIdentity)this.service.create("actIdentity.paymentProcessorParentId", ActIdentity.class);
        identity.setIdentity(Long.toString(parent.getId()));
        act.addIdentity(identity);
        IMObjectBean bean = this.service.getBean((IMObject)act);
        bean.setValue("amount", (Object)amount);
        bean.setTarget("customer", customer);
        bean.setValue("email", (Object)email);
        bean.setTarget("paymentProcessor", (IMObject)paymentProcessor);
        bean.setValue("transactionMode", (Object)mode.toString());
        bean.setTarget("location", location);
        act.setDescription(description);
        act.setStatus("PENDING");
        return act;
    }
}

